
/*
    RFC - PlatformUtil.h
    Copyright (C) 2010 Ruchira Hasaranga
  
    This software is provided 'as-is', without any express or implied
    warranty.  In no event will the authors be held liable for any damages
    arising from the use of this software.

    Permission is granted to anyone to use this software for any purpose,
    including commercial applications, and to alter it and redistribute it
    freely, subject to the following restrictions:

    1. The origin of this software must not be misrepresented; you must not
       claim that you wrote the original software. If you use this software
       in a product, an acknowledgment in the product documentation would be
       appreciated but is not required.
    2. Altered source versions must be plainly marked as such, and must not be
       misrepresented as being the original software.
    3. This notice may not be removed or altered from any source distribution.
      
*/

#ifndef _BASEUTIL_H_
#define _BASEUTIL_H_

#define _CRT_SECURE_NO_DEPRECATE

#include"../Object.h"
#include"../text/String.h"
#include<windows.h>
#include<stdio.h>
#include"../containers/PointerList.h"
#include"../gui/MenuItem.h"
#include"../threads/Timer.h"

/**
	Singleton class which can be use to get HINSTANCE of your application.
	e.g. @code
	HINSTANCE hInstance=PlatformUtil::GetInstance()->GetAppInstance();
	@endcode
*/
class PlatformUtil : public Object
{
private:

	static PlatformUtil *_instance;

	PlatformUtil();

protected:
	HINSTANCE hInstance;
	CRITICAL_SECTION g_csCount; // guard classCount variable!
	int classCount;
	int timerCount;
	UINT menuItemCount;

	PointerList<MenuItem*> *menuItemList;
	PointerList<Timer*> *timerList;

public:

	static PlatformUtil* GetInstance();

	void SetAppInstance(HINSTANCE hInstance);

	HINSTANCE GetAppInstance();

	String GenerateClassName();
	UINT GenerateMenuItemID(MenuItem *menuItem);
	MenuItem* GetMenuItemByID(UINT id);

	UINT GenerateTimerID(Timer *timer);
	Timer* GetTimerByID(UINT id);

	~PlatformUtil();

};


#endif