
/*
    RFC - Timer.h
    Copyright (C) 2010 Ruchira Hasaranga
  
    This software is provided 'as-is', without any express or implied
    warranty.  In no event will the authors be held liable for any damages
    arising from the use of this software.

    Permission is granted to anyone to use this software for any purpose,
    including commercial applications, and to alter it and redistribute it
    freely, subject to the following restrictions:

    1. The origin of this software must not be misrepresented; you must not
       claim that you wrote the original software. If you use this software
       in a product, an acknowledgment in the product documentation would be
       appreciated but is not required.
    2. Altered source versions must be plainly marked as such, and must not be
       misrepresented as being the original software.
    3. This notice may not be removed or altered from any source distribution.
      
*/

#ifndef _RFCTIMER_H_
#define _RFCTIMER_H_

#include"../gui/Window.h"
#include<windows.h>

/**
    Encapsulates a timer.

    Subclasses derive from Timer and implement the OnTimer() method, in which they
    do their business. The timer can then be started with the StartTimer() method
    and controlled with various other methods. Before you start timer, you must set 
	timer window by calling SetTimerWindow method.
*/
class Timer : public Object
{
protected:
	UINT timerID;
	int resolution;
	bool started;
	Window *window;

public:

	/**
		@param resolution timer interval
	*/
	Timer(int resolution);

	/**
		Call this method before you start timer
	*/
	virtual void SetTimerWindow(Window *window);

	virtual void SetTimerID(UINT timerID);

	/**
		@returns unique id of this timer
	*/
	virtual UINT GetTimerID();

	/**
		Starts timer
	*/
	virtual void StartTimer();

	/**
		Stops the timer. You can restart it by calling StartTimer() method.
	*/
	virtual void StopTimer();

	/**
		Override this method from your class.
	*/
	virtual void OnTimer();

	virtual ~Timer();
};

#endif