
/*
    RFC - Timer.cpp
    Copyright (C) 2010 Ruchira Hasaranga
  
    This software is provided 'as-is', without any express or implied
    warranty.  In no event will the authors be held liable for any damages
    arising from the use of this software.

    Permission is granted to anyone to use this software for any purpose,
    including commercial applications, and to alter it and redistribute it
    freely, subject to the following restrictions:

    1. The origin of this software must not be misrepresented; you must not
       claim that you wrote the original software. If you use this software
       in a product, an acknowledgment in the product documentation would be
       appreciated but is not required.
    2. Altered source versions must be plainly marked as such, and must not be
       misrepresented as being the original software.
    3. This notice may not be removed or altered from any source distribution.
      
*/

#include"../rfc.h"
#include"../utils/PlatformUtil.h"
#include"Timer.h"

Timer::Timer(int resolution)
{
	this->resolution=resolution;
	started=false;
	timerID=PlatformUtil::GetInstance()->GenerateTimerID(this);
}

void Timer::SetTimerWindow(Window *window)
{
	this->window=window;
}

void Timer::SetTimerID(UINT timerID)
{
	this->timerID=timerID;
}

UINT Timer::GetTimerID()
{
	return timerID;
}

void Timer::StartTimer()
{
	HWND hwnd;

	if(started)
		return;

	if(window)
	{
		if(hwnd=window->GetHWND())
		{
			SetTimer(hwnd,timerID,resolution,0);
			started=true;
		}
	}
}

void Timer::StopTimer()
{
	HWND hwnd;
	if(window)
	{
		if(hwnd=window->GetHWND())
		{
			if(started)
				KillTimer(hwnd,timerID);
			started=false;
		}
	}
}

void Timer::OnTimer()
{
}

Timer::~Timer()
{
	if(started)
		StopTimer();
}