
/*
    RFC Framework v0.1.6
    Copyright (C) 2010 Ruchira Hasaranga
  
    This software is provided 'as-is', without any express or implied
    warranty.  In no event will the authors be held liable for any damages
    arising from the use of this software.

    Permission is granted to anyone to use this software for any purpose,
    including commercial applications, and to alter it and redistribute it
    freely, subject to the following restrictions:

    1. The origin of this software must not be misrepresented; you must not
       claim that you wrote the original software. If you use this software
       in a product, an acknowledgment in the product documentation would be
       appreciated but is not required.
    2. Altered source versions must be plainly marked as such, and must not be
       misrepresented as being the original software.
    3. This notice may not be removed or altered from any source distribution.
      
*/

#ifndef _RFC_H_
#define _RFC_H_

#define _CRT_SECURE_NO_DEPRECATE

#include<windows.h>
#include<commctrl.h>
#pragma comment(lib,"Comctl32.lib")

#include"utils/PlatformUtil.h"
#include"Object.h"
#include"text/String.h"
#include"graphics/Font.h"
#include"gui/Component.h"
#include"gui/Window.h"
#include"gui/WindowTypes.h"
#include"gui/ButtonListener.h"
#include"gui/Button.h"
#include"gui/Label.h"
#include"gui/CheckBox.h"
#include"gui/RadioButton.h"
#include"gui/PushButton.h"
#include"gui/GroupBox.h"
#include"gui/ProgressBar.h"
#include"gui/MenuItemListener.h"
#include"gui/MenuItem.h"
#include"gui/Menu.h"
#include"gui/MenuBar.h"
#include"gui/TextBox.h"
#include"gui/PasswordBox.h"
#include"gui/TextArea.h"
#include"gui/ListBox.h"
#include"gui/ListBoxListener.h"
#include"gui/ComboBox.h"
#include"gui/ComboBoxListener.h"
#include"gui/TrackBar.h"
#include"gui/TrackBarListener.h"
#include"gui/CommonDialogBox.h"
#include"threads/Thread.h"
#include"threads/Timer.h"
#include"graphics/Icon.h"
#include"graphics/Bitmap.h"
#include"graphics/Cursor.h"
#include"gui/NumericField.h"
#include"Application.h"

LRESULT CALLBACK GlobalWnd_Proc(HWND,UINT,WPARAM,LPARAM);
DWORD WINAPI GlobalThread_Proc(LPVOID);

HWND CreateRFCComponent(Component*);
bool CreateRFCThread(Thread*);

void DoMessagePump(bool handleTabKey=true);

void InitRFC(HINSTANCE);
void DeInitRFC();

#define START_RFC_APPLICATION(AppClass) \
int WINAPI WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance,LPSTR lpCmdLine,int nCmdShow) \
{ \
	InitRFC(hInstance);\
	int argc=0;\
	LPWSTR *args=CommandLineToArgvW(GetCommandLineW(),&argc);\
	String **str_argv=(String**)malloc(argc*4);\
	for(int i=0;i<argc;i++){str_argv[i]=new String(args[i]);}\
	AppClass* application=new AppClass();\
	int retVal=application->Main(str_argv,argc);\
	delete application;\
	DeInitRFC();\
	for(int i=0;i<argc;i++){delete str_argv[i];}\
	free((void*)str_argv);\
	GlobalFree(args);\
	return retVal;\
}

// needed for supporting XP/Vista styles.
#pragma comment(linker,"/manifestdependency:\"type='win32' name='Microsoft.Windows.Common-Controls' version='6.0.0.0' processorArchitecture='x86' publicKeyToken='6595b64144ccf1df' language='*'\"")

#endif