
/*
    RFC - rfc.cpp
    Copyright (C) 2010 Ruchira Hasaranga
  
    This software is provided 'as-is', without any express or implied
    warranty.  In no event will the authors be held liable for any damages
    arising from the use of this software.

    Permission is granted to anyone to use this software for any purpose,
    including commercial applications, and to alter it and redistribute it
    freely, subject to the following restrictions:

    1. The origin of this software must not be misrepresented; you must not
       claim that you wrote the original software. If you use this software
       in a product, an acknowledgment in the product documentation would be
       appreciated but is not required.
    2. Altered source versions must be plainly marked as such, and must not be
       misrepresented as being the original software.
    3. This notice may not be removed or altered from any source distribution.
      
*/

#pragma warning(disable: 4312)
#pragma warning(disable: 4311)

#include"rfc.h"

Component *currentComponent=0;
HHOOK wnd_hook=0;
CRITICAL_SECTION g_csComponent; // guard currentComponent!

const wchar_t* RFCPropText_Object=L"RFC";
const wchar_t* RFCPropText_OldProc=L"RFCOldProc";

LRESULT CALLBACK RFCCTL_CBTProc(int nCode,WPARAM wParam,LPARAM lParam)
{
	if(nCode < 0)
        return CallNextHookEx(wnd_hook, nCode, wParam, lParam);

	if(nCode==HCBT_CREATEWND){
		HWND hwnd=(HWND)wParam;
		SetPropW(hwnd,RFCPropText_Object,(HANDLE)currentComponent);
		FARPROC lpfnOldWndProc=(FARPROC)SetWindowLongW(hwnd,GWL_WNDPROC,(LONG)GlobalWnd_Proc); // subclassing...
		SetPropW(hwnd,RFCPropText_OldProc,(HANDLE)lpfnOldWndProc);
		return 0;
	}

	// Call the next hook, if there is one
    return CallNextHookEx(wnd_hook, nCode, wParam, lParam);
}



LRESULT CALLBACK GlobalWnd_Proc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam)
{

	Component *component=(Component*)GetPropW(hwnd, RFCPropText_Object);

	if(!component){ // just for safe!
		return DefWindowProcW( hwnd, msg, wParam, lParam );
	}

	if(!component->GetHWND()) // window recieve msg for the first time!
		component->SetHWND(hwnd);

	if(msg==WM_NCDESTROY){
		RemovePropW(hwnd,RFCPropText_Object);
		FARPROC lpfnOldWndProc=(FARPROC)GetPropW(hwnd, RFCPropText_OldProc);
		if(lpfnOldWndProc)
		{
			RemovePropW(hwnd,RFCPropText_OldProc);
			SetWindowLongW(hwnd,GWL_WNDPROC,(LONG)lpfnOldWndProc); // restore default wnd proc!
			return CallWindowProcW((WNDPROC)lpfnOldWndProc, hwnd, msg, wParam,lParam);
		}
		
	}

	return component->WindowProc(hwnd,msg,wParam,lParam);
}

HWND CreateRFCComponent(Component* component)
{
	// we make thread safe this function!

	EnterCriticalSection(&g_csComponent);

	currentComponent=component;

	wnd_hook=SetWindowsHookExW(WH_CBT,&RFCCTL_CBTProc,0,GetCurrentThreadId());

	HWND hwnd=CreateWindowExW(component->GetExStyle(),(const wchar_t*)component->GetClassName(),(const wchar_t*)component->GetText(),component->GetStyle(),component->GetX(),component->GetY(),component->GetWidth(),component->GetHeight(),component->GetParentHWND(),0,PlatformUtil::GetInstance()->GetAppInstance(),0);

	UnhookWindowsHookEx(wnd_hook);

	LeaveCriticalSection(&g_csComponent);

	return hwnd;
}

void DoMessagePump(bool handleTabKey)
{
	MSG msg;
	
	while (GetMessageW(&msg, NULL, NULL, NULL)) 
	{	

		if(handleTabKey)
		{
			if(msg.message==WM_KEYDOWN)
			{
				if(VK_TAB==msg.wParam) // we need to handle tabbing!
				{
					if(msg.hwnd)
					{
						Object *object=(Object*)GetPropW(msg.hwnd, RFCPropText_Object);
						if(object)
						{
							Window *window=dynamic_cast<Window*>(object);
							if(window) // nothing selected!
							{
								HWND nextControl=GetNextDlgTabItem(msg.hwnd,NULL,FALSE);
								if(nextControl)
								{
									SetFocus(nextControl);
									continue; // don't pass this message!
								}
							}else // user has already selected component!
							{
								Component *component=dynamic_cast<Component*>(object);
								if(component)
								{
									HWND parentHWND;
									if(parentHWND=component->GetParentHWND())
									{
										HWND nextControl=GetNextDlgTabItem(parentHWND,component->GetHWND(),FALSE);
										if(nextControl)
										{
											if((GetKeyState(VK_CONTROL) & 0x8000)==0) // user is not hold ctrl key!
											{
												SetFocus(nextControl);
												continue; // don't pass this message!
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
		TranslateMessage( &msg );
		DispatchMessageW( &msg );
	} 
}

DWORD WINAPI GlobalThread_Proc(LPVOID lpParameter)
{
	if(lpParameter==0) // for safe!
		return 0;

	Object *object=(Object*)lpParameter;
	Thread* thread=dynamic_cast<Thread*>(object);
	if(thread)
	{
		thread->SetHandle(GetCurrentThread());
		thread->Run();
	}

	return 0;	
}

bool CreateRFCThread(Thread* thread)
{
	if(thread)
	{
		HANDLE handle=CreateThread(NULL,NULL,GlobalThread_Proc,thread,0,NULL);
		if(handle)
			return true;
	}
	return false;
}


void InitRFC(HINSTANCE hInstance)
{
	PlatformUtil::GetInstance()->SetAppInstance(hInstance); // create instance for first time & initialize Utility class!
	
	INITCOMMONCONTROLSEX icx;
	icx.dwSize=sizeof(INITCOMMONCONTROLSEX);
	icx.dwICC=ICC_WIN95_CLASSES;
	InitCommonControlsEx(&icx);

	InitializeCriticalSection(&g_csComponent);
}

void DeInitRFC()
{
	DeleteCriticalSection(&g_csComponent);

	// delete all singletons!
	delete Font::GetDefaultFont();
	delete PlatformUtil::GetInstance();
}