
/*
    RFC - TrackBar.cpp
    Copyright (C) 2010 Ruchira Hasaranga
  
    This software is provided 'as-is', without any express or implied
    warranty.  In no event will the authors be held liable for any damages
    arising from the use of this software.

    Permission is granted to anyone to use this software for any purpose,
    including commercial applications, and to alter it and redistribute it
    freely, subject to the following restrictions:

    1. The origin of this software must not be misrepresented; you must not
       claim that you wrote the original software. If you use this software
       in a product, an acknowledgment in the product documentation would be
       appreciated but is not required.
    2. Altered source versions must be plainly marked as such, and must not be
       misrepresented as being the original software.
    3. This notice may not be removed or altered from any source distribution.
      
*/

#include"../rfc.h"
#include"TrackBar.h"


TrackBar::TrackBar(bool showTicks,bool vertical)
{
	listener=0;
	rangeMin=0;
	rangeMax=100;
	value=0;

	SetSize(100,25);
	SetPosition(0,0);
	SetStyle(WS_TABSTOP|WS_CHILD|WS_CLIPSIBLINGS);
	SetExStyle(WS_EX_WINDOWEDGE);

	SetStyle(compDwStyle|(showTicks?TBS_AUTOTICKS:TBS_NOTICKS));
	SetStyle(compDwStyle|(vertical?TBS_VERT:TBS_HORZ));

	compClassName=String(TRACKBAR_CLASSW);
}

void TrackBar::SetRange(int min,int max)
{
	rangeMin=min;
	rangeMax=max;
	if(compHWND)
		SendMessageW(compHWND,TBM_SETRANGE,TRUE,(LPARAM) MAKELONG(min,max));	
}

void TrackBar::SetValue(int value)
{
	this->value=value;
	if(compHWND)
		SendMessageW(compHWND,TBM_SETPOS,TRUE,(LPARAM)value);
}

void TrackBar::OnChange()
{
	value=(int)SendMessageW(compHWND,TBM_GETPOS,0,0);
	if(listener)
		listener->OnTrackBarChange(this);
}

void TrackBar::SetListener(TrackBarListener *listener)
{
	this->listener=listener;
}

int TrackBar::GetValue()
{
	return value;
}

bool TrackBar::CreateComponent()
{
	if(!compParentHWND) // user must specify parent handle!
		return false;

	CreateRFCComponent(this); // we dont need to register TRACKBAR_CLASSW class!

	if(compHWND)
	{
		SendMessageW(compHWND,WM_SETFONT,(WPARAM)compFont->GetFontHandle(),MAKELPARAM(true, 0)); // set default font!

		EnableWindow(compHWND,compEnabled);

		SendMessageW(compHWND,TBM_SETRANGE,TRUE,(LPARAM) MAKELONG(rangeMin,rangeMax));	
		SendMessageW(compHWND,TBM_SETPOS,TRUE,(LPARAM)value);

		if(this->IsVisible())
			this->SetVisible(true);
		return true;
	}

	return false;
}

TrackBar::~TrackBar()
{
}

