
/*
    RFC - MenuBar.h
    Copyright (C) 2010 Ruchira Hasaranga
  
    This software is provided 'as-is', without any express or implied
    warranty.  In no event will the authors be held liable for any damages
    arising from the use of this software.

    Permission is granted to anyone to use this software for any purpose,
    including commercial applications, and to alter it and redistribute it
    freely, subject to the following restrictions:

    1. The origin of this software must not be misrepresented; you must not
       claim that you wrote the original software. If you use this software
       in a product, an acknowledgment in the product documentation would be
       appreciated but is not required.
    2. Altered source versions must be plainly marked as such, and must not be
       misrepresented as being the original software.
    3. This notice may not be removed or altered from any source distribution.
      
*/

#ifndef _MENUBAR_H_
#define _MENUBAR_H_

#include"../Object.h"
#include"Menu.h"
#include"Window.h"

class MenuBar : public Object
{
protected:
	HMENU hMenu;

public:
	MenuBar()
	{
		hMenu=CreateMenu();
	}

	virtual void AddMenu(String text,Menu *menu)
	{
		InsertMenuW(hMenu,0xFFFFFFFF,MF_BYPOSITION|MF_POPUP|MF_STRING,(UINT)menu->GetMenuHandle(),(const wchar_t*)text);
	}

	virtual void AddToWindow(Window *window)
	{
		HWND hwnd=window->GetHWND();
		if(hwnd)
			SetMenu(hwnd,hMenu);
	}

	virtual ~MenuBar()
	{
		DestroyMenu(hMenu);
	}
};


#endif