
/*
    RFC - Component.cpp
    Copyright (C) 2010 Ruchira Hasaranga
  
    This software is provided 'as-is', without any express or implied
    warranty.  In no event will the authors be held liable for any damages
    arising from the use of this software.

    Permission is granted to anyone to use this software for any purpose,
    including commercial applications, and to alter it and redistribute it
    freely, subject to the following restrictions:

    1. The origin of this software must not be misrepresented; you must not
       claim that you wrote the original software. If you use this software
       in a product, an acknowledgment in the product documentation would be
       appreciated but is not required.
    2. Altered source versions must be plainly marked as such, and must not be
       misrepresented as being the original software.
    3. This notice may not be removed or altered from any source distribution.
      
*/

#define _CRT_SECURE_NO_DEPRECATE

#include"Component.h"
#include"../rfc.h"

Component::Component()
{
	isRegistered=false;

	compClassName=PlatformUtil::GetInstance()->GenerateClassName();

	compHWND=0;
	compParentHWND=0;
	compText=String();
	compDwStyle=0;
	compDwExStyle=0;
	cursor=0;
	compX=CW_USEDEFAULT;
	compY=CW_USEDEFAULT;
	compWidth=CW_USEDEFAULT;
	compHeight=CW_USEDEFAULT;
	compVisible=true;
	compEnabled=true;

	wc.cbSize=sizeof(WNDCLASSEX);
	wc.hCursor=LoadCursor(NULL,IDC_ARROW);
	wc.hIcon=0;
	wc.lpszMenuName=0;
	wc.hbrBackground=(HBRUSH)GetSysColorBrush(COLOR_BTNFACE);
	wc.cbClsExtra=0;
	wc.cbWndExtra=0;
	wc.hIconSm=0;
	wc.style=0;
	wc.hInstance=PlatformUtil::GetInstance()->GetAppInstance();
	wc.lpszClassName=(const wchar_t*)compClassName;

	wc.lpfnWndProc=GlobalWnd_Proc;

	compFont=Font::GetDefaultFont();
}

void Component::SetMouseCursor(Cursor *cursor)
{
	this->cursor=cursor;
	if(compHWND)
		SetClassLongW(compHWND,GCL_HCURSOR,(LONG)cursor->GetHandle());
}

String Component::GetClassName()
{
	return compClassName;
}

bool Component::CreateComponent()
{
	if(!RegisterClassExW(&wc))
		return false;

	isRegistered=true;

	CreateRFCComponent(this);

	if(compHWND)
	{
		EnableWindow(compHWND,compEnabled);

		if(this->IsVisible())
			this->SetVisible(true);

		if(cursor)
			SetClassLongW(compHWND,GCL_HCURSOR,(LONG)cursor->GetHandle());

		return true;
	}
	return false;
}

LRESULT Component::WindowProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	static const wchar_t* RFCPropText_OldProc=L"RFCOldProc";

	FARPROC lpfnOldWndProc=(FARPROC)GetPropW(hwnd, RFCPropText_OldProc);
	if(lpfnOldWndProc)
		if((void*)lpfnOldWndProc!=(void*)GlobalWnd_Proc) // it's subclassed control!
			return CallWindowProcW((WNDPROC)lpfnOldWndProc, hwnd, msg, wParam,lParam);
	return DefWindowProcW(hwnd,msg,wParam,lParam);
}

void Component::SetFont(Font *compFont)
{
	this->compFont=compFont;
	if(compHWND)
		SendMessageW(compHWND,WM_SETFONT,(WPARAM)compFont->GetFontHandle(),MAKELPARAM(true, 0));
}

Font* Component::GetFont()
{
	return compFont;
}

String Component::GetText()
{
	return compText;
}

void Component::SetText(String compText)
{
	this->compText=compText;
	if(compHWND)
		SetWindowTextW(compHWND,(const wchar_t*)compText);
}

void Component::SetHWND(HWND compHWND)
{
	this->compHWND=compHWND;
}

HWND Component::GetHWND()
{
	return compHWND;
}

void Component::SetParentHWND(HWND compParentHWND)
{
	this->compParentHWND=compParentHWND;
	if(compHWND)
		SetParent(compHWND,compParentHWND);
}

HWND Component::GetParentHWND()
{
	return compParentHWND;
}

DWORD Component::GetStyle()
{
	return compDwStyle;
}

void Component::SetStyle(DWORD compStyle)
{
	this->compDwStyle=compStyle;
	if(compHWND)
		SetWindowLongW(compHWND,GWL_STYLE,compStyle);
}

DWORD Component::GetExStyle()
{
	return compDwExStyle;
}

void Component::SetExStyle(DWORD compDwExStyle)
{
	this->compDwExStyle=compDwExStyle;
	if(compHWND)
		SetWindowLongW(compHWND,GWL_EXSTYLE,compDwExStyle);
}

int Component::GetX()
{
	return compX; 
}

int Component::GetY()
{
	return compY;
}

int Component::GetWidth()
{
	return compWidth;
}

int Component::GetHeight()
{
	return compHeight;
}

void Component::SetSize(int compWidth,int compHeight)
{
	this->compWidth=compWidth;
	this->compHeight=compHeight;

	if(compHWND)
		SetWindowPos(compHWND,0,0,0,compWidth,compHeight,SWP_NOMOVE|SWP_NOREPOSITION);
}

void Component::SetPosition(int compX,int compY)
{
	this->compX=compX;
	this->compY=compY;

	if(compHWND)
		SetWindowPos(compHWND,0,compX,compY,0,0,SWP_NOSIZE|SWP_NOREPOSITION);
}

void Component::SetVisible(bool state)
{
	this->compVisible=state;
	if(compHWND)
		ShowWindow(compHWND,state ? SW_SHOW:SW_HIDE);
}

bool Component::IsVisible()
{
	return compHWND ? this->compVisible : false;
}

bool Component::IsEnabled()
{
	return compEnabled;
}

void Component::SetEnabled(bool state)
{
	compEnabled=state;

	if(compHWND)
		EnableWindow(compHWND,compEnabled);
}

void Component::BringToFront()
{
	if(compHWND)
		BringWindowToTop(compHWND);
}

void Component::SetKeyboardFocus()
{
	if(compHWND)
		SetFocus(compHWND);
}

void Component::Repaint()
{
	if(compHWND)
		InvalidateRect(compHWND, NULL, TRUE);
}

Component::~Component()
{
	if(isRegistered)
		UnregisterClassW((const wchar_t*)compClassName,PlatformUtil::GetInstance()->GetAppInstance());
}