
/*
    RFC - ComboBox.h
    Copyright (C) 2010 Ruchira Hasaranga
  
    This software is provided 'as-is', without any express or implied
    warranty.  In no event will the authors be held liable for any damages
    arising from the use of this software.

    Permission is granted to anyone to use this software for any purpose,
    including commercial applications, and to alter it and redistribute it
    freely, subject to the following restrictions:

    1. The origin of this software must not be misrepresented; you must not
       claim that you wrote the original software. If you use this software
       in a product, an acknowledgment in the product documentation would be
       appreciated but is not required.
    2. Altered source versions must be plainly marked as such, and must not be
       misrepresented as being the original software.
    3. This notice may not be removed or altered from any source distribution.
      
*/

#ifndef _COMBOBOX_H_
#define _COMBOBOX_H_

#include"Component.h"
#include"../containers/PointerList.h"


class ComboBoxListener;

class ComboBox : public Component
{
protected:
	PointerList<String*> *stringList;
	int selectedItemIndex;
	ComboBoxListener *listener;

public:
	ComboBox(bool sort=false);

	virtual void AddItem(String text);

	virtual void RemoveItem(int index);

	virtual void RemoveItem(String text);

	virtual int GetItemIndex(String text);

	virtual int GetItemCount();

	virtual int GetSelectedItemIndex();

	virtual String GetSelectedItem();

	virtual void ClearList();

	virtual void SelectItem(int index);

	virtual bool CreateComponent();

	virtual void SetListener(ComboBoxListener *listener);

	virtual void OnItemSelect();

	virtual ~ComboBox();
};

#endif