
/*
    RFC - CheckBox.cpp
    Copyright (C) 2010 Ruchira Hasaranga
  
    This software is provided 'as-is', without any express or implied
    warranty.  In no event will the authors be held liable for any damages
    arising from the use of this software.

    Permission is granted to anyone to use this software for any purpose,
    including commercial applications, and to alter it and redistribute it
    freely, subject to the following restrictions:

    1. The origin of this software must not be misrepresented; you must not
       claim that you wrote the original software. If you use this software
       in a product, an acknowledgment in the product documentation would be
       appreciated but is not required.
    2. Altered source versions must be plainly marked as such, and must not be
       misrepresented as being the original software.
    3. This notice may not be removed or altered from any source distribution.
      
*/

#define _CRT_SECURE_NO_DEPRECATE

#include"CheckBox.h"
#include"../rfc.h"

CheckBox::CheckBox()
{
	checked=false;

	SetText(L"CheckBox");
	SetStyle(WS_CHILD|WS_CLIPSIBLINGS|BS_AUTOCHECKBOX|BS_NOTIFY|WS_TABSTOP);
}

bool CheckBox::CreateComponent()
{
	if(!compParentHWND) // user must specify parent handle!
		return false;

	CreateRFCComponent(this); // we dont need to register BUTTON class!

	if(compHWND)
	{
		SendMessageW(compHWND,WM_SETFONT,(WPARAM)compFont->GetFontHandle(),MAKELPARAM(true, 0)); // set default font!
		SendMessageW(compHWND,BM_SETCHECK,checked,0);

		EnableWindow(compHWND,compEnabled);

		if(this->IsVisible())
			this->SetVisible(true);
		return true;
	}
	return false;
}

void CheckBox::OnPress()
{
	if(SendMessageW(compHWND,BM_GETCHECK,0,0)==BST_CHECKED)
		checked=true;
	else
		checked=false;

	if(listener)
		listener->OnButtonPress(this);
}

bool CheckBox::IsChecked()
{
	return checked;
}

void CheckBox::SetCheckedState(bool state)
{
	checked=state;

	if(compHWND)
		SendMessageW(compHWND,BM_SETCHECK,checked,0);
}

CheckBox::~CheckBox()
{
}