
/*
    RFC - Font.h
    Copyright (C) 2010 Ruchira Hasaranga
  
    This software is provided 'as-is', without any express or implied
    warranty.  In no event will the authors be held liable for any damages
    arising from the use of this software.

    Permission is granted to anyone to use this software for any purpose,
    including commercial applications, and to alter it and redistribute it
    freely, subject to the following restrictions:

    1. The origin of this software must not be misrepresented; you must not
       claim that you wrote the original software. If you use this software
       in a product, an acknowledgment in the product documentation would be
       appreciated but is not required.
    2. Altered source versions must be plainly marked as such, and must not be
       misrepresented as being the original software.
    3. This notice may not be removed or altered from any source distribution.
      
*/

#ifndef _FONT_H_
#define _FONT_H_

#include<windows.h>
#include"../Object.h"
#include"../text/String.h"

/**
	Can be use to create system default font or custom font. Once created, you cannot change font properties.
*/
class Font : public Object
{
private:
	static Font* defaultInstance;

protected:
	HFONT hFont;
	bool customFont;

public:
	/**
		Constructs default system Font object.
	*/
	Font()
	{
		hFont=(HFONT)GetStockObject(DEFAULT_GUI_FONT);
		customFont=false;
	}

	/**
		Constructs custom font object.
	*/
	Font(String face,int size=14,bool bold=false,bool italic=false)
	{
		hFont=CreateFontW(size, 0, 0, 0, bold?FW_BOLD:FW_NORMAL, italic?TRUE:FALSE, 0, 0, DEFAULT_CHARSET, 0, 0, 0,VARIABLE_PITCH | FF_DONTCARE,(const wchar_t*)face); 
		if(hFont)
			customFont=true;
	}

	/**
		If you want to use system default font, then use this static method. Do not delete returned object!
	*/
	static Font* GetDefaultFont()
	{
		if(defaultInstance)
			return defaultInstance;
		defaultInstance=new Font();
		return defaultInstance;
	}

	/**
		Returns font handle.
	*/
	virtual HFONT GetFontHandle()
	{
		return hFont;
	}

	virtual ~Font()
	{
		if(customFont)
			DeleteObject(hFont);
	}
};

#endif