
/*
    RFC - PlatformUtil.cpp
    Copyright (C) 2010 Ruchira Hasaranga
  
    This software is provided 'as-is', without any express or implied
    warranty.  In no event will the authors be held liable for any damages
    arising from the use of this software.

    Permission is granted to anyone to use this software for any purpose,
    including commercial applications, and to alter it and redistribute it
    freely, subject to the following restrictions:

    1. The origin of this software must not be misrepresented; you must not
       claim that you wrote the original software. If you use this software
       in a product, an acknowledgment in the product documentation would be
       appreciated but is not required.
    2. Altered source versions must be plainly marked as such, and must not be
       misrepresented as being the original software.
    3. This notice may not be removed or altered from any source distribution.
      
*/

#include"../utils/PlatformUtil.h"
#include"../gui/MenuItem.h"

PlatformUtil* PlatformUtil::_instance=0;

PlatformUtil::PlatformUtil()
{
	timerCount=0;
	classCount=0;
	menuItemCount=0;
	hInstance=0;
	InitializeCriticalSection(&g_csCount);
	menuItemList=new PointerList<MenuItem*>();
	timerList=new PointerList<Timer*>();
}

PlatformUtil* PlatformUtil::GetInstance()
{
	if(_instance)
		return _instance;
	_instance=new PlatformUtil();
	return _instance;
}

void PlatformUtil::SetAppInstance(HINSTANCE hInstance)
{
	this->hInstance=hInstance;
}

HINSTANCE PlatformUtil::GetAppInstance()
{
	return hInstance;
}

UINT PlatformUtil::GenerateMenuItemID(MenuItem *menuItem)
{
	EnterCriticalSection(&g_csCount);
	menuItemCount++;
	menuItemList->AddPointer(menuItem);
	LeaveCriticalSection(&g_csCount);
	return menuItemCount+30000;
}

MenuItem* PlatformUtil::GetMenuItemByID(UINT id)
{
	return menuItemList->GetPointer(id-30001);
}

String PlatformUtil::GenerateClassName()
{
	EnterCriticalSection(&g_csCount);
	static wchar_t className[32];
	swprintf(className,32,L"RFC_%d",1000+classCount);
	classCount++;
	LeaveCriticalSection(&g_csCount);
	return String(className);
}

UINT PlatformUtil::GenerateTimerID(Timer *timer)
{
	EnterCriticalSection(&g_csCount);
	timerCount++;
	timerList->AddPointer(timer);
	LeaveCriticalSection(&g_csCount);
	return timerCount+1000;
}

Timer* PlatformUtil::GetTimerByID(UINT id)
{
	return timerList->GetPointer(id-1001);
}

PlatformUtil::~PlatformUtil()
{
	delete menuItemList;
	delete timerList;
	DeleteCriticalSection(&g_csCount);
}