
/*
    RFC - Thread.h
    Copyright (C) 2010 Ruchira Hasaranga
  
    This software is provided 'as-is', without any express or implied
    warranty.  In no event will the authors be held liable for any damages
    arising from the use of this software.

    Permission is granted to anyone to use this software for any purpose,
    including commercial applications, and to alter it and redistribute it
    freely, subject to the following restrictions:

    1. The origin of this software must not be misrepresented; you must not
       claim that you wrote the original software. If you use this software
       in a product, an acknowledgment in the product documentation would be
       appreciated but is not required.
    2. Altered source versions must be plainly marked as such, and must not be
       misrepresented as being the original software.
    3. This notice may not be removed or altered from any source distribution.
      
*/

#ifndef _RFCTHREAD_H_
#define _RFCTHREAD_H_

#include"../Object.h"
#include<windows.h>

/**
    Encapsulates a thread.

    Subclasses derive from Thread and implement the Run() method, in which they
    do their business. The thread can then be started with the StartThread() method
    and controlled with various other methods.

	Run() method implementation might be like this
	@code
	virtual void Run()
	{
		while(!threadShouldStop)
		{
			// your code goes here...
		}
		isThreadRunning=false;	
	}
	@endcode

*/
class Thread : public Object
{
protected:
	HANDLE handle;
	bool isThreadRunning;
	bool threadShouldStop;
public:
	Thread();

	/**
		Sets thread handle.
	*/
	virtual void SetHandle(HANDLE handle);

	/**
		Returns handle of the thread
	*/
	virtual HANDLE GetHandle();

	/**
		Override this method in your class.
	*/
	virtual void Run();

	/**
		Starts thread
	*/
	virtual bool StartThread();

	/**
		Another thread can signal this thread should stop. 
	*/
	virtual void ThreadShouldStop();

	/**
		@returns true if thread is still running
	*/
	virtual bool IsThreadRunning();

	/**
		Calling thread is not return until this thread finish.
	*/
	virtual void WaitUntilThreadFinish();

	virtual ~Thread();
};

#endif