
/*
    RFC - WindowTypes.h
    Copyright (C) 2010 Ruchira Hasaranga
  
    This software is provided 'as-is', without any express or implied
    warranty.  In no event will the authors be held liable for any damages
    arising from the use of this software.

    Permission is granted to anyone to use this software for any purpose,
    including commercial applications, and to alter it and redistribute it
    freely, subject to the following restrictions:

    1. The origin of this software must not be misrepresented; you must not
       claim that you wrote the original software. If you use this software
       in a product, an acknowledgment in the product documentation would be
       appreciated but is not required.
    2. Altered source versions must be plainly marked as such, and must not be
       misrepresented as being the original software.
    3. This notice may not be removed or altered from any source distribution.
      
*/

#ifndef _WINDOWTYPES_H_
#define _WINDOWTYPES_H_

#include"Window.h"

class OverlappedWindow : public Window
{
public:
	OverlappedWindow()
	{
		SetText(L"RFC Overlapped Window");
		SetStyle(WS_OVERLAPPEDWINDOW);

		CreateComponent();
	}

	virtual ~OverlappedWindow(){}
};

class Frame : public Window
{
public:
	Frame()
	{
		SetText(L"RFC Frame");
		SetStyle(WS_POPUP|WS_CAPTION|WS_SYSMENU|WS_MINIMIZEBOX);

		CreateComponent();
	}

	virtual ~Frame(){}
};

class Dialog : public Window
{
public:
	Dialog()
	{
		SetText(L"RFC Dialog");
		SetStyle(WS_POPUP|WS_CAPTION|WS_SYSMENU);

		CreateComponent();
	}

	virtual ~Dialog(){}
};

class ToolWindow : public Window
{
public:
	ToolWindow()
	{
		SetText(L"RFC Tool Window");
		SetStyle(WS_OVERLAPPED|WS_SYSMENU);
		SetExStyle(WS_EX_TOOLWINDOW);
		CreateComponent();
	}

	virtual ~ToolWindow(){}
};

#endif