
/*
    RFC - Window.cpp
    Copyright (C) 2010 Ruchira Hasaranga
  
    This software is provided 'as-is', without any express or implied
    warranty.  In no event will the authors be held liable for any damages
    arising from the use of this software.

    Permission is granted to anyone to use this software for any purpose,
    including commercial applications, and to alter it and redistribute it
    freely, subject to the following restrictions:

    1. The origin of this software must not be misrepresented; you must not
       claim that you wrote the original software. If you use this software
       in a product, an acknowledgment in the product documentation would be
       appreciated but is not required.
    2. Altered source versions must be plainly marked as such, and must not be
       misrepresented as being the original software.
    3. This notice may not be removed or altered from any source distribution.
      
*/

#define _CRT_SECURE_NO_DEPRECATE

#include"Window.h"
#include"../rfc.h"

#pragma warning(disable: 4312)

Window::Window()
{
	SetText(L"RFCWindow");
	SetSize(400,200);
	SetVisible(false);
	SetStyle(WS_POPUP);
	SetExStyle(WS_EX_APPWINDOW|WS_EX_ACCEPTFILES|WS_EX_CONTROLPARENT);
	wc.style=CS_OWNDC|CS_HREDRAW|CS_VREDRAW;
}

void Window::SetIcon(Icon *icon)
{
	SetClassLongW(compHWND,GCL_HICON,(LONG)icon->GetHandle());
}

void Window::OnClose()
{
	DestroyWindow(compHWND);
}

void Window::OnDestroy()
{
	PostQuitMessage(0);
}

void Window::CenterScreen()
{
	SetPosition((GetSystemMetrics(SM_CXSCREEN)-compWidth)/2,(GetSystemMetrics(SM_CYSCREEN)-compHeight)/2);
}

bool Window::AddComponent(Component *component)
{
	if(component)
	{
		if(compHWND)
		{
			component->SetParentHWND(compHWND);
			return component->CreateComponent();
		}
	}
	return false;
}


LRESULT Window::WindowProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	static const wchar_t* RFCPropText_Object=L"RFC";

	switch(msg)
	{
		case WM_COMMAND:
			{
				if(HIWORD(wParam)==BN_CLICKED) // button, checkbox, radio button or menu clicked event!
				{
					if(lParam)
					{
						Object *object=(Object*)GetPropW((HWND)lParam, RFCPropText_Object);
						Button *btn=dynamic_cast<Button*>(object);

						if(btn) // button, checkbox or radio button!
						{
							btn->OnPress();
							break;
						}
					}else // its menu item! unfortunately windows does not send menu handle with clicked event!
					{
						MenuItem *menuItem=PlatformUtil::GetInstance()->GetMenuItemByID(LOWORD(wParam));
						if(menuItem)
						{
							menuItem->OnPress();
							break;
						}
					}
				}else if(HIWORD(wParam)==LBN_SELCHANGE) // listbox sel change!
				{
					Object *object=(Object*)GetPropW((HWND)lParam, RFCPropText_Object);
					ListBox *listBox=dynamic_cast<ListBox*>(object);
					if(listBox)
					{
						listBox->OnItemSelect();
						break;
					}
				}else if(HIWORD(wParam)==CBN_SELENDOK) // combobox sel change!
				{
					Object *object=(Object*)GetPropW((HWND)lParam, RFCPropText_Object);
					ComboBox *comboBox=dynamic_cast<ComboBox*>(object);
					if(comboBox)
					{
						comboBox->OnItemSelect();
						break;
					}
				}
			}
			return Component::WindowProc(hwnd,msg,wParam,lParam);

		case WM_HSCROLL:
		case WM_VSCROLL:
			{
				int nScrollCode = (int)LOWORD(wParam);

				if( (TB_THUMBTRACK==nScrollCode)||(TB_LINEDOWN==nScrollCode) || (TB_LINEUP==nScrollCode) || (TB_BOTTOM==nScrollCode) || (TB_TOP==nScrollCode) || (TB_PAGEUP==nScrollCode) || (TB_PAGEDOWN==nScrollCode) ) // its trackbar!
				{
					Object *object=(Object*)GetPropW((HWND)lParam, RFCPropText_Object);
					TrackBar *trackBar=dynamic_cast<TrackBar*>(object);
					if(trackBar)
					{
						trackBar->OnChange();
						break;
					}
				}
			}
			return Component::WindowProc(hwnd,msg,wParam,lParam);

		case WM_TIMER:
			{
				Timer *timer=PlatformUtil::GetInstance()->GetTimerByID((UINT)wParam);
				if(timer)
				{
					timer->OnTimer();
					break;
				}
			}
			return Component::WindowProc(hwnd,msg,wParam,lParam);

		case WM_CLOSE:
			OnClose();
			break;
		case WM_DESTROY:
			OnDestroy();
			break;

		default:
			return Component::WindowProc(hwnd,msg,wParam,lParam);
	}
	return 0;
}


Window::~Window()
{

}