
/*
    RFC - Menu.h
    Copyright (C) 2010 Ruchira Hasaranga
  
    This software is provided 'as-is', without any express or implied
    warranty.  In no event will the authors be held liable for any damages
    arising from the use of this software.

    Permission is granted to anyone to use this software for any purpose,
    including commercial applications, and to alter it and redistribute it
    freely, subject to the following restrictions:

    1. The origin of this software must not be misrepresented; you must not
       claim that you wrote the original software. If you use this software
       in a product, an acknowledgment in the product documentation would be
       appreciated but is not required.
    2. Altered source versions must be plainly marked as such, and must not be
       misrepresented as being the original software.
    3. This notice may not be removed or altered from any source distribution.
      
*/

#ifndef _MENU_H_
#define _MENU_H_

#pragma warning(disable: 4311)

#include"../Object.h"
#include"MenuItem.h"
#include"Window.h"

class Menu : public Object
{
protected:
	HMENU hMenu;

public:
	Menu()
	{
		hMenu=CreatePopupMenu();
	}

	virtual void AddMenuItem(MenuItem *menuItem)
	{
		menuItem->AddToMenu(hMenu);
	}

	virtual void AddSubMenu(String text,Menu *menu)
	{
		InsertMenuW(hMenu,0xFFFFFFFF,MF_BYPOSITION|MF_POPUP|MF_STRING,(UINT)menu->GetMenuHandle(),(const wchar_t*)text);
	}

	virtual void AddSeperator()
	{
		MENUITEMINFOW mii;
		ZeroMemory(&mii, sizeof(mii));

		mii.cbSize=sizeof(MENUITEMINFOW);
		mii.fMask=MIIM_TYPE;
		mii.fType=MFT_SEPARATOR;

		InsertMenuItemW(hMenu,0xFFFFFFFF,FALSE,&mii);
	}

	virtual HMENU GetMenuHandle()
	{
		return hMenu;
	}

	virtual void PopUpMenu(Window *window)
	{
		if(window)
		{
			POINT p;
			GetCursorPos(&p);
			TrackPopupMenu(hMenu, TPM_LEFTBUTTON, p.x, p.y, 0, window->GetHWND(), NULL);
		}
	}

	virtual ~Menu()
	{
		DestroyMenu(hMenu);
	}
};

#endif