
/*
    RFC - ListBox.cpp
    Copyright (C) 2010 Ruchira Hasaranga
  
    This software is provided 'as-is', without any express or implied
    warranty.  In no event will the authors be held liable for any damages
    arising from the use of this software.

    Permission is granted to anyone to use this software for any purpose,
    including commercial applications, and to alter it and redistribute it
    freely, subject to the following restrictions:

    1. The origin of this software must not be misrepresented; you must not
       claim that you wrote the original software. If you use this software
       in a product, an acknowledgment in the product documentation would be
       appreciated but is not required.
    2. Altered source versions must be plainly marked as such, and must not be
       misrepresented as being the original software.
    3. This notice may not be removed or altered from any source distribution.
      
*/

#include"../rfc.h"
#include"ListBox.h"

ListBox::ListBox(bool multipleSelection,bool sort,bool vscroll)
{
	this->multipleSelection=multipleSelection;
	listener=0;

	selectedItemIndex=-1;
	selectedItemEnd=-1;

	compClassName=String(L"LISTBOX");

	SetSize(100,100);
	SetPosition(0,0);

	SetStyle(LBS_NOTIFY|WS_CHILD|WS_CLIPSIBLINGS|WS_TABSTOP);

	if(multipleSelection)
		SetStyle(compDwStyle|LBS_MULTIPLESEL);
	if(sort)
		SetStyle(compDwStyle|LBS_SORT);
	if(vscroll)
		SetStyle(compDwStyle|WS_VSCROLL);

	SetExStyle(WS_EX_CLIENTEDGE|WS_EX_WINDOWEDGE);

	stringList=new PointerList<String*>;
}

void ListBox::SetListener(ListBoxListener *listener)
{
	this->listener=listener;
}

void ListBox::AddItem(String text)
{
	String *str=new String(text);
	stringList->AddPointer(str);
	if(compHWND)
		SendMessageW(compHWND,LB_ADDSTRING,0,(LPARAM)(const wchar_t*)*str);
}

void ListBox::RemoveItem(int index)
{
	stringList->RemovePointer(index);

	if(compHWND)	 
		SendMessageW(compHWND,LB_DELETESTRING,index,0);
}

void ListBox::RemoveItem(String text)
{
	int itemIndex=GetItemIndex(text);
	if(itemIndex>-1)
		RemoveItem(itemIndex);
}

int ListBox::GetItemIndex(String text)
{
	int listSize=stringList->GetSize();
	if(listSize)
	{
		for(int i=0;i<listSize;i++)
		{
			if(stringList->GetPointer(i)->EqualsIgnoreCase(text))
				return i;
		}
	}
	return -1;
}

int ListBox::GetItemCount()
{
	return stringList->GetSize();
}

int ListBox::GetSelectedItemIndex()
{
	if(compHWND)
	{	 
		int index=(int)SendMessageW(compHWND,LB_GETCURSEL,0,0);
		if(index!=LB_ERR)
			return index;
		return -1;
	}else
	{
		return -1;
	}	
}

String ListBox::GetSelectedItem()
{
	int itemIndex=GetSelectedItemIndex();
	if(itemIndex>-1)
		return *stringList->GetPointer(itemIndex);
	return String();
}

int ListBox::GetSelectedItems(int* itemArray,int itemCountInArray)
{
	if(compHWND)
	{	 
		int items=(int)SendMessageW(compHWND,LB_GETSELITEMS,itemCountInArray,(LPARAM)itemArray);
		if(items!=LB_ERR)
			return items;
		return -1;
	}else
	{
		return -1;
	}
}

void ListBox::ClearList()
{
	stringList->DeleteAll();
	if(compHWND)
	{
		SendMessageW(compHWND,LB_RESETCONTENT,0,0);
	}
}

void ListBox::SelectItem(int index)
{
	selectedItemIndex=index;
	if(compHWND)
	{
		SendMessageW(compHWND,LB_SETCURSEL,index,0);
	}
}

void ListBox::SelectItems(int start,int end)
{
	if(multipleSelection)
	{
		selectedItemIndex=start;
		selectedItemEnd=end;

		if(compHWND)
			SendMessageW(compHWND,LB_SELITEMRANGE,TRUE,MAKELPARAM(start,end));
	}
}

bool ListBox::CreateComponent()
{
	if(!compParentHWND) // user must specify parent handle!
		return false;

	CreateRFCComponent(this); // we dont need to register LISTBOX class!

	if(compHWND)
	{
		SendMessageW(compHWND,WM_SETFONT,(WPARAM)compFont->GetFontHandle(),MAKELPARAM(true, 0)); // set default font!

		EnableWindow(compHWND,compEnabled);

		int listSize=stringList->GetSize();
		if(listSize)
		{
			for(int i=0;i<listSize;i++)
				SendMessageW(compHWND,LB_ADDSTRING,0,(LPARAM)(const wchar_t*)*stringList->GetPointer(i));
		}

		if(!multipleSelection) // single selction!
		{
			if(selectedItemIndex>-1)
				SendMessageW(compHWND,LB_SETCURSEL,selectedItemIndex,0);
		}else
		{
			if(selectedItemIndex>-1)
				SendMessageW(compHWND,LB_SELITEMRANGE,TRUE,MAKELPARAM(selectedItemIndex,selectedItemEnd));
		}

		if(this->IsVisible())
			this->SetVisible(true);
		return true;
	}

	return false;
}

void ListBox::OnItemSelect()
{
	if(listener)
		listener->OnListBoxItemSelect(this);
}

ListBox::~ListBox()
{
	stringList->DeleteAll();
	delete stringList;
}