
/*
    RFC - Component.h
    Copyright (C) 2010 Ruchira Hasaranga
  
    This software is provided 'as-is', without any express or implied
    warranty.  In no event will the authors be held liable for any damages
    arising from the use of this software.

    Permission is granted to anyone to use this software for any purpose,
    including commercial applications, and to alter it and redistribute it
    freely, subject to the following restrictions:

    1. The origin of this software must not be misrepresented; you must not
       claim that you wrote the original software. If you use this software
       in a product, an acknowledgment in the product documentation would be
       appreciated but is not required.
    2. Altered source versions must be plainly marked as such, and must not be
       misrepresented as being the original software.
    3. This notice may not be removed or altered from any source distribution.
      
*/

#ifndef _COMPONENT_H_
#define _COMPONENT_H_

#include"../Object.h"
#include<windows.h>
#include"../graphics/Font.h"
#include"../graphics/Cursor.h"
#include"../text/String.h"

/**
	Base class of all W32 gui objects.
*/
class Component : public Object
{
protected:
	String compClassName;
	String compText;
	HWND compHWND;
	HWND compParentHWND;
	DWORD compDwStyle;
	DWORD compDwExStyle;
	int compX;
	int compY;
	int compWidth;
	int compHeight;
	bool compVisible;
	bool compEnabled;
	bool isRegistered;
	Font *compFont;
	Cursor *cursor;

public:
	WNDCLASSEXW wc;

	Component();

	/**
		Sets mouse cursor of this component.
	*/
	virtual void SetMouseCursor(Cursor *cursor);

	/**
		@returns autogenerated unique class name for this component
	*/
	virtual String GetClassName();

	/**
		Registers the class name and creates the component. 
		@returns false if registration failed or component creation failed.
	*/
	virtual bool CreateComponent();

	/**
		Handles windows messages. 
		Important: Pass unprocessed messages to parent if you override this method.
	*/
	virtual LRESULT WindowProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);

	/**
		Sets font of this component
	*/
	virtual void SetFont(Font *compFont);

	/**
		Returns font of this component
	*/
	virtual Font* GetFont();

	/**
		Returns caption of this component
	*/
	virtual String GetText();

	/**
		Sets caption of this component
	*/
	virtual void SetText(String compText);

	virtual void SetHWND(HWND compHWND);

	/**
		Returns HWND of this component
	*/
	virtual HWND GetHWND();

	/**
		Changes parent of this component
	*/
	virtual void SetParentHWND(HWND compParentHWND);

	/**
		Returns parent of this component
	*/
	virtual HWND GetParentHWND();

	/**
		Returns style of this component
	*/
	virtual DWORD GetStyle();

	/**
		Sets style of this component
	*/
	virtual void SetStyle(DWORD compStyle);

	/**
		Returns exstyle of this component
	*/
	virtual DWORD GetExStyle();

	/**
		Sets exstyle of this component
	*/
	virtual void SetExStyle(DWORD compExStyle);

	/**
		Returns x position of this component which is relative to parent component.
	*/
	virtual int GetX();

	/**
		Returns y position of this component which is relative to parent component.
	*/
	virtual int GetY();

	/**
		Returns width of the component.
	*/
	virtual int GetWidth();

	/**
		Returns height of the component.
	*/
	virtual int GetHeight();

	/**
		Sets width and height of the component.
	*/
	virtual void SetSize(int compWidth,int compHeight);

	/**
		Sets x and y position of the component. x and y are relative to parent component
	*/
	virtual void SetPosition(int compX,int compY);

	/**
		Sets visible state of the component
	*/
	virtual void SetVisible(bool state);

	/**
		Returns visible state of the component
	*/
	virtual bool IsVisible();

	/**
		Returns the component is ready for user input or not
	*/
	virtual bool IsEnabled();

	/**
		Sets component's user input reading state
	*/
	virtual void SetEnabled(bool state);

	/**
		Brings component to front
	*/
	virtual void BringToFront();

	/**
		Grabs keyboard focus into this component
	*/
	virtual void SetKeyboardFocus();

	/**
		Repaints the component
	*/
	virtual void Repaint();

	virtual ~Component();

};

#endif