
/*
    RFC - CommonDialogBox.h
    Copyright (C) 2010 Ruchira Hasaranga
  
    This software is provided 'as-is', without any express or implied
    warranty.  In no event will the authors be held liable for any damages
    arising from the use of this software.

    Permission is granted to anyone to use this software for any purpose,
    including commercial applications, and to alter it and redistribute it
    freely, subject to the following restrictions:

    1. The origin of this software must not be misrepresented; you must not
       claim that you wrote the original software. If you use this software
       in a product, an acknowledgment in the product documentation would be
       appreciated but is not required.
    2. Altered source versions must be plainly marked as such, and must not be
       misrepresented as being the original software.
    3. This notice may not be removed or altered from any source distribution.
      
*/

#ifndef _COMMONDIALOGBOX_H_
#define _COMMONDIALOGBOX_H_

#include"../Object.h"
#include"Window.h"
#include"../text/String.h"

class CommonDialogBox : public Object
{
public:
	/**
		Filter string might be like this "Text Files (*.txt)\0*.txt\0"
		You cannot use String object for filter, because filter string contains multiple null characters.
	*/
	bool ShowOpenFileDialog(Window *window,String title,wchar_t* filter,String *fileName)
	{
		OPENFILENAMEW ofn;
		static wchar_t buff[MAX_PATH];

		ZeroMemory(&ofn, sizeof(OPENFILENAMEW));

		ofn.lStructSize = sizeof(OPENFILENAMEW);
		ofn.hwndOwner = window->GetHWND();
		ofn.lpstrFilter = filter;
		ofn.lpstrFile = buff;
		ofn.nMaxFile = MAX_PATH;
		ofn.Flags =  OFN_FILEMUSTEXIST|OFN_HIDEREADONLY;
		ofn.lpstrTitle = (const wchar_t*)title;

		if(GetOpenFileNameW(&ofn))
		{
			*fileName=String(buff);
			return true;
		}else
		{
			return false;
		}
	}

	/**
		Filter string might be like this "Text Files (*.txt)\0*.txt\0"
		You cannot use String object for filter, because filter string contains multiple null characters.
	*/
	bool ShowSaveFileDialog(Window *window,String title,wchar_t* filter,String *fileName)
	{
		OPENFILENAMEW ofn;
		static wchar_t buff[MAX_PATH];

		ZeroMemory(&ofn, sizeof(OPENFILENAMEW));

		ofn.lStructSize = sizeof(OPENFILENAMEW);
		ofn.hwndOwner = window->GetHWND();
		ofn.lpstrFilter = filter;
		ofn.lpstrFile = buff;
		ofn.nMaxFile = MAX_PATH;
		ofn.Flags =  OFN_FILEMUSTEXIST|OFN_HIDEREADONLY;
		ofn.lpstrTitle = (const wchar_t*)title;

		if(GetSaveFileNameW(&ofn))
		{
			*fileName=String(buff);
			return true;
		}else
		{
			return false;
		}
	}
};

#endif