
/*
    RFC - ComboBox.cpp
    Copyright (C) 2010 Ruchira Hasaranga
  
    This software is provided 'as-is', without any express or implied
    warranty.  In no event will the authors be held liable for any damages
    arising from the use of this software.

    Permission is granted to anyone to use this software for any purpose,
    including commercial applications, and to alter it and redistribute it
    freely, subject to the following restrictions:

    1. The origin of this software must not be misrepresented; you must not
       claim that you wrote the original software. If you use this software
       in a product, an acknowledgment in the product documentation would be
       appreciated but is not required.
    2. Altered source versions must be plainly marked as such, and must not be
       misrepresented as being the original software.
    3. This notice may not be removed or altered from any source distribution.
      
*/

#include"../rfc.h"
#include"ComboBox.h"


ComboBox::ComboBox(bool sort)
{
	listener=0;
	selectedItemIndex=-1;

	compClassName=String(L"COMBOBOX");

	SetSize(100,100);
	SetPosition(0,0);

	SetStyle(WS_VSCROLL|CBS_DROPDOWNLIST|WS_CHILD|WS_CLIPSIBLINGS|WS_TABSTOP);

	if(sort)
		SetStyle(compDwStyle|CBS_SORT);

	SetExStyle(WS_EX_CLIENTEDGE|WS_EX_WINDOWEDGE);

	stringList=new PointerList<String*>;
}

void ComboBox::AddItem(String text)
{
	String *str=new String(text);
	stringList->AddPointer(str);
	if(compHWND)
		SendMessageW(compHWND,CB_ADDSTRING,0,(LPARAM)(const wchar_t*)*str);
}

void ComboBox::RemoveItem(int index)
{
	stringList->RemovePointer(index);

	if(compHWND)	 
		SendMessageW(compHWND,CB_DELETESTRING,index,0);
}

void ComboBox::RemoveItem(String text)
{
	int itemIndex=GetItemIndex(text);
	if(itemIndex>-1)
		RemoveItem(itemIndex);
}

int ComboBox::GetItemIndex(String text)
{
	int listSize=stringList->GetSize();
	if(listSize)
	{
		for(int i=0;i<listSize;i++)
		{
			if(stringList->GetPointer(i)->EqualsIgnoreCase(text))
				return i;
		}
	}
	return -1;
}

int ComboBox::GetItemCount()
{
	return stringList->GetSize();
}

int ComboBox::GetSelectedItemIndex()
{
	if(compHWND)
	{	 
		int index=(int)SendMessageW(compHWND,CB_GETCURSEL,0,0);
		if(index!=CB_ERR)
			return index;
		return -1;
	}else
	{
		return -1;
	}	
}

String ComboBox::GetSelectedItem()
{
	int itemIndex=GetSelectedItemIndex();
	if(itemIndex>-1)
		return *stringList->GetPointer(itemIndex);
	return String();
}

void ComboBox::ClearList()
{
	stringList->DeleteAll();
	if(compHWND)
	{
		SendMessageW(compHWND,CB_RESETCONTENT,0,0);
	}
}

void ComboBox::SelectItem(int index)
{
	selectedItemIndex=index;
	if(compHWND)
	{
		SendMessageW(compHWND,CB_SETCURSEL,index,0);
	}
}

bool ComboBox::CreateComponent()
{
	if(!compParentHWND) // user must specify parent handle!
		return false;

	CreateRFCComponent(this); // we dont need to register COMBOBOX class!

	if(compHWND)
	{
		SendMessageW(compHWND,WM_SETFONT,(WPARAM)compFont->GetFontHandle(),MAKELPARAM(true, 0)); // set default font!

		EnableWindow(compHWND,compEnabled);

		int listSize=stringList->GetSize();
		if(listSize)
		{
			for(int i=0;i<listSize;i++)
				SendMessageW(compHWND,CB_ADDSTRING,0,(LPARAM)(const wchar_t*)*stringList->GetPointer(i));
		}

		if(selectedItemIndex>-1)
			SendMessageW(compHWND,CB_SETCURSEL,selectedItemIndex,0);


		if(this->IsVisible())
			this->SetVisible(true);
		return true;
	}

	return false;
}

void ComboBox::SetListener(ComboBoxListener *listener)
{
	this->listener=listener;
}

void ComboBox::OnItemSelect()
{
	if(listener)
		listener->OnComboBoxItemSelect(this);
}

ComboBox::~ComboBox()
{
	stringList->DeleteAll();
	delete stringList;
}


