
/*
    RFC - Bitmap.cpp
    Copyright (C) 2010 Ruchira Hasaranga
  
    This software is provided 'as-is', without any express or implied
    warranty.  In no event will the authors be held liable for any damages
    arising from the use of this software.

    Permission is granted to anyone to use this software for any purpose,
    including commercial applications, and to alter it and redistribute it
    freely, subject to the following restrictions:

    1. The origin of this software must not be misrepresented; you must not
       claim that you wrote the original software. If you use this software
       in a product, an acknowledgment in the product documentation would be
       appreciated but is not required.
    2. Altered source versions must be plainly marked as such, and must not be
       misrepresented as being the original software.
    3. This notice may not be removed or altered from any source distribution.
      
*/

#include"../utils/PlatformUtil.h"
#include"../graphics/Bitmap.h"

Bitmap::Bitmap()
{
	hBitmap=0;
	appInstance=PlatformUtil::GetInstance()->GetAppInstance();
}

bool Bitmap::LoadFromResource(WORD resourceID)
{
	hBitmap=(HBITMAP)LoadImageW(appInstance,MAKEINTRESOURCEW(resourceID),IMAGE_BITMAP,0,0,LR_DEFAULTSIZE|LR_DEFAULTCOLOR);
	if(hBitmap)
		return true;	
	return false;
}

bool Bitmap::LoadFromFile(String filePath)
{
	hBitmap=(HBITMAP)LoadImageW(appInstance,(const wchar_t*)filePath,IMAGE_BITMAP,0,0,LR_LOADFROMFILE|LR_DEFAULTSIZE|LR_DEFAULTCOLOR);
	if(hBitmap)
		return true;	
	return false;
}

HBITMAP Bitmap::GetHandle()
{
	return hBitmap;
}

Bitmap::~Bitmap()
{
	if(hBitmap)
		DeleteObject(hBitmap);
}