

#include"resource.h"

#include"rfc/rfc.h"

#include "asiosys.h"
#include "asio.h"
#include "asiodrivers.h"

#include"dsp.h"
bool loadAsioDriver(char *name); 

// name of the ASIO device to be used
#define ASIO_DRIVER_NAME    "ASIO4ALL v2"

HMODULE dspLib=0;
winampDSPModule* dspModule=0;

enum {
	// number of input and outputs supported by the host application
	// you can change these to higher or lower values
	kMaxInputChannels = 32,
	kMaxOutputChannels = 32
};

// internal data storage
typedef struct DriverInfo
{
	// ASIOInit()
	ASIODriverInfo driverInfo;

	// ASIOGetChannels()
	long           inputChannels;
	long           outputChannels;

	// ASIOGetBufferSize()
	long           minSize;
	long           maxSize;
	long           preferredSize;
	long           granularity;

	// ASIOGetSampleRate()
	ASIOSampleRate sampleRate;

	// ASIOOutputReady()
	bool           postOutput;

	// ASIOGetLatencies ()
	long           inputLatency;
	long           outputLatency;

	// ASIOCreateBuffers ()
	long inputBuffers;	// becomes number of actual created input buffers
	long outputBuffers;	// becomes number of actual created output buffers
	ASIOBufferInfo bufferInfos[kMaxInputChannels + kMaxOutputChannels]; // buffer info's

	// ASIOGetChannelInfo()
	ASIOChannelInfo channelInfos[kMaxInputChannels + kMaxOutputChannels]; // channel info's
	// The above two arrays share the same indexing, as the data in them are linked together

	// Information from ASIOGetSamplePosition()
	// data is converted to double floats for easier use, however 64 bit integer can be used, too
	double         nanoSeconds;
	double         samples;
	double         tcSamples;	// time code samples

	// bufferSwitchTimeInfo()
	ASIOTime       tInfo;			// time info state
	unsigned long  sysRefTime;      // system reference time, when bufferSwitch() was called

	// Signal the end of processing in this example
	bool           stopped;
} DriverInfo;


DriverInfo asioDriverInfo = {0};
ASIOCallbacks asioCallbacks;

short int* wampBuffer;




ASIOTime *bufferSwitchTimeInfo(ASIOTime *timeInfo, long index, ASIOBool processNow)
{	// the actual processing callback.
	
	static long processedSamples = 0;

	// store the timeInfo for later use
	asioDriverInfo.tInfo = *timeInfo;

	// buffer size in samples
	long buffSize = asioDriverInfo.preferredSize;

	// perform the processing

	if(asioDriverInfo.channelInfos[0].type==ASIOSTInt32LSB)
	{
		int* inbufL = (int*)asioDriverInfo.bufferInfos[0].buffers[index];
		int* inbufR = (int*)asioDriverInfo.bufferInfos[1].buffers[index];

		int* outbufL = (int*)asioDriverInfo.bufferInfos[asioDriverInfo.inputBuffers].buffers[index];
		int* outbufR=(int*)asioDriverInfo.bufferInfos[asioDriverInfo.inputBuffers+1].buffers[index];

		for (int j = 0,i=0; j < buffSize; j++,i+=2)
		{
			wampBuffer[i]=inbufL[j]>>16;
			wampBuffer[i+1]=inbufR[j]>>16;
		}

		dspModule->ModifySamples(dspModule,wampBuffer,buffSize,16,2,44100);	

		for (int j = 0,i=0; j < buffSize; j++,i+=2)
		{
			outbufL[j]=wampBuffer[i]<<16;
			outbufR[j]=wampBuffer[i+1]<<16;
		}
	}else if(asioDriverInfo.channelInfos[0].type==ASIOSTInt24LSB)
	{
		char* inbufL = (char*)asioDriverInfo.bufferInfos[0].buffers[index];
		char* inbufR = (char*)asioDriverInfo.bufferInfos[1].buffers[index];

		char* outbufL = (char*)asioDriverInfo.bufferInfos[asioDriverInfo.inputBuffers].buffers[index];
		char* outbufR = (char*)asioDriverInfo.bufferInfos[asioDriverInfo.inputBuffers+1].buffers[index];

		for (int j = 0,i=0; j < (buffSize*3); j+=3,i+=2)
		{
			char byte1=inbufL[j+1];
			char byte2=inbufL[j+2];
			wampBuffer[i]=0;
			wampBuffer[i]= wampBuffer[i]|byte2;
			wampBuffer[i]= wampBuffer[i]<<8;
			wampBuffer[i]= wampBuffer[i]|byte1;

			byte1=inbufR[j+1];
			byte2=inbufR[j+2];
			wampBuffer[i+1]=0;
			wampBuffer[i+1]= wampBuffer[i+1]|byte2;
			wampBuffer[i+1]= wampBuffer[i+1]<<8;
			wampBuffer[i+1]= wampBuffer[i+1]|byte1;
		}

		dspModule->ModifySamples(dspModule,wampBuffer,buffSize,16,2,44100);	

		for (int j = 0,i=0; j < (buffSize*3); j+=3,i+=2)
		{
			outbufL[j]=0;
			outbufL[j+1]= wampBuffer[i] & 0xff;
			outbufL[j+2]= (wampBuffer[i] & 0xff00)>>8;

			outbufR[j]=0;
			outbufR[j+1]= wampBuffer[i+1] & 0xff;
			outbufR[j+2]= (wampBuffer[i+1] & 0xff00)>>8;
		}

	}

   //memcpy (asioDriverInfo.bufferInfos[asioDriverInfo.inputBuffers].buffers[index], asioDriverInfo.bufferInfos[0].buffers[index], buffSize * 4);
   //memcpy (asioDriverInfo.bufferInfos[asioDriverInfo.inputBuffers+1].buffers[index], asioDriverInfo.bufferInfos[1].buffers[index], buffSize * 4);


	// finally if the driver supports the ASIOOutputReady() optimization, do it here, all data are in place
	if (asioDriverInfo.postOutput)
		ASIOOutputReady();

	processedSamples += buffSize;

	return 0L;
}

void bufferSwitch(long index, ASIOBool processNow)
{	// the actual processing callback.

	ASIOTime  timeInfo;
	memset (&timeInfo, 0, sizeof (timeInfo));

	// get the time stamp of the buffer, not necessary if no
	// synchronization to other media is required
	if(ASIOGetSamplePosition(&timeInfo.timeInfo.samplePosition, &timeInfo.timeInfo.systemTime) == ASE_OK)
		timeInfo.timeInfo.flags = kSystemTimeValid | kSamplePositionValid;

	bufferSwitchTimeInfo (&timeInfo, index, processNow);
}


void sampleRateChanged(ASIOSampleRate sRate)
{

}

long asioMessages(long selector, long value, void* message, double* opt)
{
	return 1L;
}


ASIOError create_asio_buffers (DriverInfo *asioDriverInfo)
{	// create buffers for all inputs and outputs of the card with the 
	// preferredSize from ASIOGetBufferSize() as buffer size
	long i;
	ASIOError result;

	// fill the bufferInfos from the start without a gap
	ASIOBufferInfo *info = asioDriverInfo->bufferInfos;

	// prepare inputs (Though this is not necessaily required, no opened inputs will work, too
	if (asioDriverInfo->inputChannels > kMaxInputChannels)
		asioDriverInfo->inputBuffers = kMaxInputChannels;
	else
		asioDriverInfo->inputBuffers = asioDriverInfo->inputChannels;
	for(i = 0; i < asioDriverInfo->inputBuffers; i++, info++)
	{
		info->isInput = ASIOTrue;
		info->channelNum = i;
		info->buffers[0] = info->buffers[1] = 0;
	}

	// prepare outputs
	if (asioDriverInfo->outputChannels > kMaxOutputChannels)
		asioDriverInfo->outputBuffers = kMaxOutputChannels;
	else
		asioDriverInfo->outputBuffers = asioDriverInfo->outputChannels;
	for(i = 0; i < asioDriverInfo->outputBuffers; i++, info++)
	{
		info->isInput = ASIOFalse;
		info->channelNum = i;
		info->buffers[0] = info->buffers[1] = 0;
	}

	// create and activate buffers
	result = ASIOCreateBuffers(asioDriverInfo->bufferInfos,
		asioDriverInfo->inputBuffers + asioDriverInfo->outputBuffers,
		asioDriverInfo->preferredSize, &asioCallbacks);
	if (result == ASE_OK)
	{
		// now get all the buffer details, sample word length, name, word clock group and activation
		for (i = 0; i < asioDriverInfo->inputBuffers + asioDriverInfo->outputBuffers; i++)
		{
			asioDriverInfo->channelInfos[i].channel = asioDriverInfo->bufferInfos[i].channelNum;
			asioDriverInfo->channelInfos[i].isInput = asioDriverInfo->bufferInfos[i].isInput;
			result = ASIOGetChannelInfo(&asioDriverInfo->channelInfos[i]);
			if (result != ASE_OK)
				break;
		}

		if (result == ASE_OK)
		{
			result = ASIOGetLatencies(&asioDriverInfo->inputLatency, &asioDriverInfo->outputLatency);
		}
	}
	return result;
}




void init_asio_static_data (DriverInfo *asioDriverInfo)
{	// collect the informational data of the driver

	ASIOGetChannels(&asioDriverInfo->inputChannels, &asioDriverInfo->outputChannels);
	ASIOGetBufferSize(&asioDriverInfo->minSize, &asioDriverInfo->maxSize, &asioDriverInfo->preferredSize, &asioDriverInfo->granularity);
	ASIOSetSampleRate(44100.0);
	ASIOOutputReady();
}


extern AsioDrivers* asioDrivers;

class XAudioGUI : public Frame , public ButtonListener
{
Button confBtn,abtBtn;
Icon icon;
public:
	XAudioGUI(String appPath)
	{
		String pluginPath=appPath+L"\\dsp_dee.dll";
		dspLib=LoadLibraryW(pluginPath);
		winampDSPGetHeaderType getHeader=(winampDSPGetHeaderType)GetProcAddress(dspLib,"winampDSPGetHeader2");
		dspModule=getHeader()->getModule(0);
		dspModule->hwndParent=compHWND;
		dspModule->hDllInstance=dspLib;
		dspModule->Init(dspModule);

		loadAsioDriver(ASIO_DRIVER_NAME);
		ASIOInit (&asioDriverInfo.driverInfo);
		init_asio_static_data (&asioDriverInfo);

		wampBuffer=(short int*)malloc(asioDriverInfo.preferredSize*2*2);

		// set up the asioCallback structure and create the ASIO data buffer
		asioCallbacks.bufferSwitch = &bufferSwitch;
		asioCallbacks.sampleRateDidChange = &sampleRateChanged;
		asioCallbacks.asioMessage = &asioMessages;
		asioCallbacks.bufferSwitchTimeInfo = &bufferSwitchTimeInfo;

		create_asio_buffers (&asioDriverInfo);

		SetText("XAudio");
		SetSize(150,135);

		confBtn.SetText("Config");
		confBtn.SetPosition(20,20);
		confBtn.SetListener(this);

		abtBtn.SetText("About");
		abtBtn.SetPosition(20,60);
		abtBtn.SetListener(this);

		AddComponent(&confBtn);
		AddComponent(&abtBtn);

		icon.LoadFromResource(IDI_ICON1);
		SetIcon(&icon);

		ASIOStart();

		
	}


	void OnButtonPress(Button *button)
	{
		if(button==&confBtn)
		{
			dspModule->Config(dspModule);
		}else if(button==&abtBtn)
		{
			MessageBoxW(compHWND,L"XAudio v1.0\n\nCreated with RFC Framework v0.1.6\nCoded by Ruchira Hasaranga\nUses ASIO technology.",L"About",MB_ICONINFORMATION);
		}
	}

	void OnClose()
	{
		ASIOStop();
		ASIODisposeBuffers();
		ASIOExit();
		asioDrivers->removeCurrentDriver();

		dspModule->Quit(dspModule);
		FreeLibrary(dspLib);

		free(wampBuffer);

		DestroyWindow(compHWND);
	}
};

class XAudioApp: Application
{
public:
	int Main(String **argv,int argc)
	{

		// setup path...
		static wchar_t path[MAX_PATH];
		GetModuleFileNameW(PlatformUtil::GetInstance()->GetAppInstance(),path,MAX_PATH);

		wchar_t *p;
		for (p = path; *p; p++) { }	// find end
		for (; p > path && *p != '\\'; p--) { } // back up to last backslash
		*p = 0;	// kill it

		XAudioGUI gui(path);
		gui.CenterScreen();
		gui.SetVisible(true);
		
		DoMessagePump();

		return 0;
	}
};

START_RFC_APPLICATION(XAudioApp)