

#include<windows.h>
#include"stubgen.h"

class Window
{	
public:
	char* wndProcStub;

	Window()
	{
		wndProcStub=0;
	}

	LRESULT wndProc(HWND hWnd, UINT msg, WPARAM wParam,LPARAM lParam )
	{
		switch( msg ) {

			case WM_DESTROY:
				PostQuitMessage( 0 );
				break;

			default:
				return( DefWindowProc( hWnd, msg, wParam, lParam ));
		}

		return 0;
	}

	~Window()
	{
		if(wndProcStub)
			GlobalFree(wndProcStub);
	}
};


int WINAPI WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance,LPSTR lpCmdLine,int nCmdShow)
{

	WNDCLASSEX wndClass;

	wndClass.lpszClassName = L"GenericAppClass";
	wndClass.style = CS_OWNDC | CS_VREDRAW | CS_HREDRAW;
	wndClass.hInstance = hInstance;
	wndClass.hIcon = LoadIcon( NULL, IDI_APPLICATION );
	wndClass.hCursor = LoadCursor( NULL, IDC_ARROW );
	wndClass.hbrBackground = (HBRUSH)( COLOR_WINDOW+1 );
	wndClass.lpszMenuName = 0;
	wndClass.cbClsExtra = 0;
	wndClass.cbWndExtra = 0;
	wndClass.cbSize=sizeof(wndClass);

	Window* wnd=new Window();

	void* pointer;

	GET_POINTER(Window::wndProc,pointer)	// get pointer to member function!

	wnd->wndProcStub=generateStub(wnd,pointer); // generate asm stub for window proc

	wndClass.lpfnWndProc=(WNDPROC)wnd->wndProcStub; // set the stub as callback function!

	RegisterClassEx(&wndClass);

	HWND hwnd=CreateWindowEx(WS_EX_APPWINDOW,wndClass.lpszClassName,L"Test",WS_OVERLAPPED|WS_SYSMENU,CW_USEDEFAULT,CW_USEDEFAULT,400,200,0,0,hInstance,0);

	ShowWindow(hwnd,SW_SHOW);

	MSG msg;

	while( GetMessage( &msg, NULL, 0, 0 ) ) {
		TranslateMessage( &msg );
		DispatchMessage( &msg );
	}

	delete wnd;

	return 0;

}

