
#include "XmlParser.h"
#include "XmlParser_guid.h"
#include "XmlElement.h"


RCOMObject* XmlParser::InitUsingFile(RCOMString *text)
{
	doc = new TiXmlDocument(text->GetString());
	
	if(doc->LoadFile())
	{
		TiXmlElement* pElem = doc->FirstChildElement();
		
		if(pElem)
			return new XmlElement(pElem);
	}

	return 0;
}


XmlParser::XmlParser()
{
	doc = 0;
 	INITIALIZE_RCOM_OBJECT_PROPERTIES
}

XmlParser::~XmlParser() 
{
	if(doc)
		delete doc;

	RELEASE_RCOM_OBJECT_PROPERTIES	
}

int XmlParser::GetInterfaceIndex(const GUID *interfaceID)
{
	if(IsEqualGUID(*interfaceID, IID_IXML_PARSER))
		return 0;
	return UNSUPPORTED_INTERFACE;
}

int XmlParser::_GetTypeInfo(int interfaceIndex, int methodID, int paramIndex)
{
	if(interfaceIndex==0)
	{
		if(methodID == IXmlParser::IXMLPARSER_INIT_USING_FILE)
		{
			if(paramIndex == 0)
				return STRING_TYPE;
			else if(paramIndex == RETURN_TYPE_INDEX)
				return RCOM_OBJECT_TYPE;
			else
				return INVALID_PARAM;
		}

		if(parent)
			return parent->_GetTypeInfo(interfaceIndex, methodID, paramIndex);

		return UNSUPPORTED_METHOD;
	}

	if(parent)
		return parent->_GetTypeInfo(interfaceIndex, methodID, paramIndex);

	return UNSUPPORTED_INTERFACE;
}

int XmlParser::_Invoke(int interfaceIndex, int methodID, void **params, int nparam, void *retval)
{
	if(interfaceIndex==0)
	{
		if(methodID==IXmlParser::IXMLPARSER_INIT_USING_FILE)
		{
			cb(&XmlParser::InitUsingFile, retval, params);
			return DISPATCH_SUCCESS;
		}

		if(parent)
			return parent->_Invoke(interfaceIndex, methodID, params, nparam, retval);

		return UNSUPPORTED_METHOD;
	}

	if(parent)
		return parent->_Invoke(interfaceIndex, methodID, params, nparam, retval);

	return UNSUPPORTED_INTERFACE;	
}

#define RC_CLASS XmlParser
	IMPLEMENTS_REFERENCE_COUNT
	IMPLEMENTS_GET_CLASS_ID(CLSID_XML_PARSER)
	IMPLEMENTS_OVERRIDE_INVOKE
	IMPLEMENTS_SET_PARENT
	REDIRECT_GET_TYPE_INFO
	REDIRECT_INVOKE
#undef RC_CLASS

