
#include"XmlElement.h"


RCOMString* XmlElement::GetTagName()
{
	const char* res = pElem->Value();

	if(res)
		return MakeString(res);

	return 0;
}

RCOMObject* XmlElement::GetFirstChildElement()
{
	TiXmlElement* res = pElem->FirstChildElement();
		
	if(res)
		return new XmlElement(res);

	return 0;
}

RCOMObject* XmlElement::GetNextElement()
{
	TiXmlElement* res = pElem->NextSiblingElement();
		
	if(res)
		return new XmlElement(res);

	return 0;
}

RCOMString* XmlElement::GetText()
{
	const char* res = pElem->GetText();

	if(res)
		return MakeString(res);

	return 0;
}

RCOMString* XmlElement::GetStringAttributeValue(RCOMString* attributeName)
{
	const char* res = pElem->Attribute(attributeName->GetString());

	if(res)
		return MakeString(res);

	return 0;
}

int XmlElement::GetIntAttributeValue(RCOMString* attributeName, int defVal)
{
	pElem->QueryIntAttribute(attributeName->GetString(), &defVal);
	return defVal;
}

int XmlElement::GetNumAttributes()
{
	TiXmlAttribute* pAttrib = pElem->FirstAttribute();

	if(pAttrib)
	{
		int i = 0;
		while(pAttrib)
		{
			++i;
			pAttrib = pAttrib->Next();
		}
		return i;
	}

	return 0;	
}

RCOMString* XmlElement::GetAttributeName(int attributeIndex)
{
	TiXmlAttribute* pAttrib = pElem->FirstAttribute();

	if(pAttrib)
	{
		int i = 0;
		while(pAttrib)
		{
			if(i == attributeIndex)
			{
				const char* res = pAttrib->Name();

				if(res)
					return MakeString(res);
				return 0;
			}

			++i;
			pAttrib = pAttrib->Next();
		}
	}

	return 0;
}

bool XmlElement::HasAttribute(RCOMString* attributeName)
{
	TiXmlAttribute* pAttrib = pElem->FirstAttribute();

	if(pAttrib)
	{
		while(pAttrib)
		{
			if(strcmp(pAttrib->Name(), attributeName->GetString()) == 0)
				return true;

			pAttrib = pAttrib->Next();
		}
	}
	return false;
}

XmlElement::XmlElement(TiXmlElement* pElem)
{
	this->pElem = pElem;

 	INITIALIZE_RCOM_OBJECT_PROPERTIES
}

XmlElement::~XmlElement() 
{
	RELEASE_RCOM_OBJECT_PROPERTIES	
}

int XmlElement::GetInterfaceIndex(const GUID *interfaceID)
{
	if(IsEqualGUID(*interfaceID, IID_IXML_ELEMENT))
		return 0;
	return UNSUPPORTED_INTERFACE;
}

int XmlElement::_GetTypeInfo(int interfaceIndex, int methodID, int paramIndex)
{
	if(interfaceIndex==0)
	{
		if(methodID == IXmlElement::IXMLELEMENT_GET_TAG_NAME)
		{
			if(paramIndex == RETURN_TYPE_INDEX)
				return STRING_TYPE;
			else
				return INVALID_PARAM;
		}else if(methodID == IXmlElement::IXMLELEMENT_GET_FIRST_CHILD_ELEMENT)
		{
			if(paramIndex == RETURN_TYPE_INDEX)
				return RCOM_OBJECT_TYPE;
			else
				return INVALID_PARAM;
		}else if(methodID == IXmlElement::IXMLELEMENT_GET_NEXT_ELEMENT)
		{
			if(paramIndex == RETURN_TYPE_INDEX)
				return RCOM_OBJECT_TYPE;
			else
				return INVALID_PARAM;
		}else if(methodID == IXmlElement::IXMLELEMENT_GET_TEXT)
		{
			if(paramIndex == RETURN_TYPE_INDEX)
				return STRING_TYPE;
			else
				return INVALID_PARAM;
		}else if(methodID == IXmlElement::IXMLELEMENT_GET_STRING_ATTR_VALUE)
		{
			if( (paramIndex == RETURN_TYPE_INDEX) || (paramIndex == 0) )
				return STRING_TYPE;
			else
				return INVALID_PARAM;
		}else if(methodID == IXmlElement::IXMLELEMENT_GET_INT_ATTR_VALUE)
		{
			if(paramIndex == 0)
				return STRING_TYPE;
			else if( (paramIndex == RETURN_TYPE_INDEX) || (paramIndex == 1) )
				return INT_TYPE;
			else
				return INVALID_PARAM;
		}else if(methodID == IXmlElement::IXMLELEMENT_GET_NUM_ATTR)
		{
			if(paramIndex == RETURN_TYPE_INDEX)
				return INT_TYPE;
			else
				return INVALID_PARAM;
		}else if(methodID == IXmlElement::IXMLELEMENT_GET_ATTR_NAME)
		{
			if(paramIndex == 0)
				return INT_TYPE;
			else if(paramIndex == RETURN_TYPE_INDEX)
				return STRING_TYPE;
			else
				return INVALID_PARAM;
		}else if(methodID == IXmlElement::IXMLELEMENT_HAS_ATTRIBUTE)
		{
			if(paramIndex == 0)
				return STRING_TYPE;
			else if(paramIndex == RETURN_TYPE_INDEX)
				return BOOL_TYPE;
			else
				return INVALID_PARAM;
		}

		if(parent)
			return parent->_GetTypeInfo(interfaceIndex, methodID, paramIndex);

		return UNSUPPORTED_METHOD;
	}

	if(parent)
		return parent->_GetTypeInfo(interfaceIndex, methodID, paramIndex);

	return UNSUPPORTED_INTERFACE;
}

int XmlElement::_Invoke(int interfaceIndex, int methodID, void **params, int nparam, void *retval)
{
	if(interfaceIndex==0)
	{
		if(methodID==IXmlElement::IXMLELEMENT_GET_TAG_NAME)
		{
			cb(&XmlElement::GetTagName, retval, params);
			return DISPATCH_SUCCESS;
		}else if(methodID==IXmlElement::IXMLELEMENT_GET_FIRST_CHILD_ELEMENT)
		{
			cb(&XmlElement::GetFirstChildElement, retval, params);
			return DISPATCH_SUCCESS;
		}else if(methodID==IXmlElement::IXMLELEMENT_GET_NEXT_ELEMENT)
		{
			cb(&XmlElement::GetNextElement, retval, params);
			return DISPATCH_SUCCESS;
		}else if(methodID==IXmlElement::IXMLELEMENT_GET_TEXT)
		{
			cb(&XmlElement::GetText, retval, params);
			return DISPATCH_SUCCESS;
		}else if(methodID==IXmlElement::IXMLELEMENT_GET_STRING_ATTR_VALUE)
		{
			cb(&XmlElement::GetStringAttributeValue, retval, params);
			return DISPATCH_SUCCESS;
		}else if(methodID==IXmlElement::IXMLELEMENT_GET_INT_ATTR_VALUE)
		{
			cb(&XmlElement::GetIntAttributeValue, retval, params);
			return DISPATCH_SUCCESS;
		}else if(methodID==IXmlElement::IXMLELEMENT_GET_NUM_ATTR)
		{
			cb(&XmlElement::GetNumAttributes, retval, params);
			return DISPATCH_SUCCESS;
		}else if(methodID==IXmlElement::IXMLELEMENT_GET_ATTR_NAME)
		{
			cb(&XmlElement::GetAttributeName, retval, params);
			return DISPATCH_SUCCESS;
		}else if(methodID==IXmlElement::IXMLELEMENT_HAS_ATTRIBUTE)
		{
			cb(&XmlElement::HasAttribute, retval, params);
			return DISPATCH_SUCCESS;
		}

		if(parent)
			return parent->_Invoke(interfaceIndex, methodID, params, nparam, retval);

		return UNSUPPORTED_METHOD;
	}

	if(parent)
		return parent->_Invoke(interfaceIndex, methodID, params, nparam, retval);

	return UNSUPPORTED_INTERFACE;	
}

#define RC_CLASS XmlElement
	IMPLEMENTS_REFERENCE_COUNT
	IMPLEMENTS_GET_CLASS_ID(IID_IXML_ELEMENT) // clsid not used. so, no need to use another guid.
	IMPLEMENTS_OVERRIDE_INVOKE
	IMPLEMENTS_SET_PARENT
	REDIRECT_GET_TYPE_INFO
	REDIRECT_INVOKE
#undef RC_CLASS

