#ifndef _PXML_ELEMENT_H_
#define _PXML_ELEMENT_H_

#include "../rcom.h"
#include "IXmlElement.h"
#include <string.h>

class PXmlElement: public ClientHelper
{
protected:
	RCOMObject *obj;
	int interfaceIndex;

public:

	PXmlElement(RCOMObject *obj)
	{
		this->obj = obj;
		interfaceIndex=obj->GetInterfaceIndex(&IID_IXML_ELEMENT);
	}

	~PXmlElement()
	{
		if(obj)
			obj->Release();
	}

	const char* GetTagName()
	{
		RCOMString* retVal=0;
		_call(obj, interfaceIndex, IXmlElement::IXMLELEMENT_GET_TAG_NAME, &retVal);

		if(retVal)
		{
			const char* str = strdup(retVal->GetString());
			retVal->Release();
			return str;
		}

		return 0;
	}

	PXmlElement* GetFirstChildElement()
	{
		RCOMObject* retVal=0;
		_call(obj, interfaceIndex, IXmlElement::IXMLELEMENT_GET_FIRST_CHILD_ELEMENT, &retVal);

		if(retVal)
			return new PXmlElement(retVal);

		return 0;
	}

	PXmlElement* GetNextElement()
	{
		RCOMObject* retVal=0;
		_call(obj, interfaceIndex, IXmlElement::IXMLELEMENT_GET_NEXT_ELEMENT, &retVal);

		if(retVal)
			return new PXmlElement(retVal);

		return 0;
	}

	const char* GetText()
	{
		RCOMString* retVal=0;
		_call(obj, interfaceIndex, IXmlElement::IXMLELEMENT_GET_TEXT, &retVal);

		if(retVal)
		{
			const char* str = strdup(retVal->GetString());
			retVal->Release();
			return str;
		}

		return 0;
	}

	const char* GetStringAttributeValue(const char* attributeName)
	{
		RCOMString* strAttributeName = MakeString(attributeName);
		RCOMString* retVal=0;

		_call(obj, interfaceIndex, IXmlElement::IXMLELEMENT_GET_STRING_ATTR_VALUE, strAttributeName, &retVal);

		strAttributeName->Release();

		if(retVal)
		{
			const char* str = strdup(retVal->GetString());
			retVal->Release();
			return str;
		}

		return 0;		
	}

	int GetIntAttributeValue(const char* attributeName, int defVal)
	{
		RCOMString* strAttributeName = MakeString(attributeName);
		int retVal=defVal;

		_call(obj, interfaceIndex, IXmlElement::IXMLELEMENT_GET_INT_ATTR_VALUE, strAttributeName, defVal, &retVal);

		strAttributeName->Release();

		return retVal;
	}

	int GetNumAttributes()
	{
		int retVal=0;
		_call(obj, interfaceIndex, IXmlElement::IXMLELEMENT_GET_NUM_ATTR, &retVal);

		return retVal;
	}

	const char* GetAttributeName(int attributeIndex)
	{
		RCOMString* retVal=0;

		_call(obj, interfaceIndex, IXmlElement::IXMLELEMENT_GET_ATTR_NAME, attributeIndex, &retVal);

		if(retVal)
		{
			const char* str = strdup(retVal->GetString());
			retVal->Release();
			return str;
		}

		return 0;
	}

	bool HasAttribute(const char* attributeName)
	{
		RCOMString* strAttributeName = MakeString(attributeName);
		bool retVal=false;

		_call(obj, interfaceIndex, IXmlElement::IXMLELEMENT_HAS_ATTRIBUTE, strAttributeName, &retVal);

		strAttributeName->Release();

		return retVal;
	}

};

#endif
