#ifndef _PSTD_LIB_H_
#define _PSTD_LIB_H_

#include"../rcom.h"
#include"SimpleFactory_guid.h"
#include"StdLib_guid.h"
#include"IStdLib.h"

class PStdLib: public ClientHelper
{
protected:
	RCOMObject *obj;
	int interfaceIndex;

public:

	PStdLib()
	{
		obj=0;
	}

	~PStdLib()
	{
		if(obj)
			obj->Release();
	}

	bool AcquireRCOMObject(RCOMSystemAPI *systemAPI)
	{
		if(obj)
			obj->Release();

		obj=systemAPI->GetObjectFromFactory(&CLSID_SIMPLE_FACTORY,&CLSID_STDLIB);
		if(obj)
		{
			interfaceIndex=obj->GetInterfaceIndex(&IID_ISTDLIB);
			if(interfaceIndex!=UNSUPPORTED_INTERFACE)
				return true;

			obj->Release();
			obj=0;
		}
		return false;
	}

	int Add(int x,int y)
	{
		int retVal=0;
		_call(obj,interfaceIndex, IStdLib::ISTDLIB_ADD,x,y,&retVal);
		
		return retVal;
	}

	void SetText(RCOMString *text)
	{
		_voidcall(obj,interfaceIndex, IStdLib::ISTDLIB_SET_TEXT,text);
	}
};

#endif