
#ifndef _SYSTEM_API_H_
#define _SYSTEM_API_H_

#include "../rcom.h"
#include "KPointerList.h"
#include "PNewInstanceListener.h"

class FactoryHolder
{
public:
	RCOMFactory* factory;
	bool initOK;
};

class RCOMLoader;

class SystemAPI: public RCOMSystemAPI
{
protected:
	KPointerList<FactoryHolder*> *factoryList;
	volatile bool shutdownCalled;
	int nNumArgs;
	char **args;
	RCOMLoader *loader;

public:
	PNewInstanceListener *newInstanceListener;
	
	bool RCALL IsFactoryAvailable(const GUID *factID);
	RCOMObject* RCALL GetObjectFromFactory(const GUID *factID, const GUID *clsID);
	bool RCALL ShutdownSystem();
	char* RCALL GetApplicationDir();
	int RCALL GetCommandlineArgCount();
	char* RCALL GetCommandlineArgument(int index);
	bool RCALL LoadComponent(char* path);
	void RCALL SetNewInstanceListener(RCOMObject *newInstanceListener);
	RCOMObject* RCALL GetNewInstanceListener();

	void AddFactory(RCOMFactory *factory, bool runComponent = false);
	void InitAll();
	void ExecAll();
	void StopAll();
	void QuitAll();
	void ReleaseAllFactories();	

	SystemAPI(int argc, char* argv[], RCOMLoader *loader);
	~SystemAPI();
};

#endif

