
#include"PXmlParser.h"

// {D3B85E86-5C60-4f6d-8594-870F5F6C92F0}
static const GUID CLSID_MyFactory = { 0xd3b85e86, 0x5c60, 0x4f6d, { 0x85, 0x94, 0x87, 0xf, 0x5f, 0x6c, 0x92, 0xf0 } };


RCOMSystemAPI *systemAPI;


class MyFactory : public RCOMFactory
{
protected:
	long refCount;

public:

	MyFactory()
	{
		refCount=1;
	}

	long RCALL AddRef()
	{
		ADD_REF_CODE
	}

	long RCALL Release()
	{
		RELEASE_CODE
	}	

	bool RCALL Init(RCOMSystemAPI *_systemAPI,bool isFinal)
	{
		systemAPI = _systemAPI;

		return true;
	}

	void RCALL Exec()
	{
		PXmlParser xmlParser;
		
		if(xmlParser.AcquireRCOMObject(systemAPI))
		{
			PXmlElement* firstElement = xmlParser.InitUsingFile("main.xml");
			if(firstElement)
			{
				const char* tagName = firstElement->GetTagName();
				if(tagName)
				{
					printf("\ntag name: %s\n", tagName);
					free((void*)tagName);
				}
				delete firstElement;
			}
		}
	}

	RCOMObject* RCALL QueryObject(const GUID *clsID)
	{
		return 0;	
	}

	void RCALL Stop()
	{

	}

	void RCALL Quit()
	{
		
	}

	const GUID* RCALL GetFactoryID()
	{
		return &CLSID_MyFactory;
	}


};


RCOM_LIB_EXPORT RCOMFactory* GetRCOMFactory(int index)
{
	if(index==0)
		return (RCOMFactory*)(new MyFactory());
	return 0;
}

