
#include"../rcom.h"
#include"NewInstanceListener.h"

static const GUID CLSID_MyFactory = { 0xd3e85e87, 0x5c60, 0x4f6d, { 0x85, 0x94, 0x87, 0xf, 0x5f, 0x6c, 0x92, 0xf0 } };


RCOMSystemAPI *systemAPI;


class MyFactory : public RCOMFactory
{
protected:
	long refCount;

public:

	MyFactory()
	{
		refCount=1;
	}

	long RCALL AddRef()
	{
		ADD_REF_CODE
	}

	long RCALL Release()
	{
		RELEASE_CODE
	}	

	bool RCALL Init(RCOMSystemAPI *_systemAPI,bool isFinal)
	{
		systemAPI = _systemAPI;

		RCOMObject *newInstanceListener=new NewInstanceListener();

		RCOMObject *currentListener=systemAPI->GetNewInstanceListener();
		if(currentListener) // listener already exists! lets hook it.
		{
			currentListener->OverrideInvoke(newInstanceListener);
			currentListener->Release();
		}else
		{
			systemAPI->SetNewInstanceListener(newInstanceListener);
		}

		newInstanceListener->Release();
		return true;
	}

	void RCALL Exec()
	{

	}

	RCOMObject* RCALL QueryObject(const GUID *clsID)
	{
		return 0;	
	}

	void RCALL Stop()
	{

	}

	void RCALL Quit()
	{
		
	}

	const GUID* RCALL GetFactoryID()
	{
		return &CLSID_MyFactory;
	}


};


extern "C" __declspec(dllexport) RCOMFactory* GetRCOMFactory(int index)
{
	if(index==0)
		return (RCOMFactory*)(new MyFactory());
	return 0;
}