
#include "NewInstanceListener.h"

// {81FEB3F2-3567-4402-8321-26CA3A124054}
static const GUID CLSID_NEWINSTANCELISTENER = { 0x81feb3f2, 0x3567, 0x4402, { 0x83, 0x21, 0x26, 0xca, 0x3a, 0x12, 0x40, 0x54 } };


void NewInstanceListener::OnNewInstanceStart(RCOMString **args,int argc)
{

	for(int i=0;i<argc;i++)
		MessageBoxW(0,args[i]->GetString(),L"new instance cmdline",0);

	if(parent)
	{
		// call parent method
		int retval=0;
		void *params[2] = { &args, &argc };
		parent->_Invoke(0, INewInstanceListener::INEWINSTANCELISTENER_ON_NEW_INSTANCE_START, params, 2, &retval);
	}
}

NewInstanceListener::NewInstanceListener()
{
 	INITIALIZE_RCOM_OBJECT_PROPERTIES
}

NewInstanceListener::~NewInstanceListener() 
{
	RELEASE_RCOM_OBJECT_PROPERTIES	
}

int NewInstanceListener::GetInterfaceIndex(const GUID *interfaceID)
{
	if(IsEqualGUID(*interfaceID,IID_INEWINSTANCELISTENER))
		return 0;
	return UNSUPPORTED_INTERFACE;
}

int NewInstanceListener::_GetTypeInfo(int interfaceIndex, int methodID, int paramIndex)
{
	if(interfaceIndex==0)
	{
		if(methodID==INewInstanceListener::INEWINSTANCELISTENER_ON_NEW_INSTANCE_START)
		{
			if(paramIndex == 0)
				return REFERENCE_TYPE;
			else if(paramIndex == 1)
				return INT_TYPE;
			else if(paramIndex == RETURN_TYPE_INDEX)
				return VOID_TYPE;
			else
				return INVALID_PARAM;
		}
		if(parent)
			return parent->_GetTypeInfo(interfaceIndex, methodID, paramIndex);
		return UNSUPPORTED_METHOD;
	}
	if(parent)
		return parent->_GetTypeInfo(interfaceIndex, methodID, paramIndex);
	return UNSUPPORTED_INTERFACE;
}

int NewInstanceListener::_Invoke(int interfaceIndex, int methodID, void **params, int nparam, void *retval)
{
	if(interfaceIndex==0)
	{
		if(methodID==INewInstanceListener::INEWINSTANCELISTENER_ON_NEW_INSTANCE_START)
		{
			vcb(&NewInstanceListener::OnNewInstanceStart, params);
			return DISPATCH_SUCCESS;
		}

		if(parent)
			return parent->_Invoke(interfaceIndex, methodID, params, nparam, retval);
		return UNSUPPORTED_METHOD;
	}
	if(parent)
		return parent->_Invoke(interfaceIndex, methodID, params, nparam, retval);
	return UNSUPPORTED_INTERFACE;	
}

#define RC_CLASS NewInstanceListener
	IMPLEMENTS_REFERENCE_COUNT
	IMPLEMENTS_GET_CLASS_ID(CLSID_NEWINSTANCELISTENER)
	IMPLEMENTS_OVERRIDE_INVOKE
	IMPLEMENTS_SET_PARENT
	REDIRECT_GET_TYPE_INFO
	REDIRECT_INVOKE
#undef RC_CLASS