

#include"../rcom.h"
#include"SimpleFactory_guid.h"
#include"StdLib_guid.h"
#include"StdLib.h"

HWND pluginWindow;
RCOMSystemAPI *systemAPI;


LRESULT CALLBACK MainWndProc(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam)
{
	switch ( message )
	{
	case WM_CLOSE: // we are not destroy window here coz others might be using it
		systemAPI->ShutdownSystem();
		return 0;
	}
	return DefWindowProcW(hwnd, message, wParam, lParam);
}

class SimpleFactory : public RCOMFactory
{
protected:
	long refCount;
	
	StdLib *stdLib;
public:

	SimpleFactory()
	{
		refCount=1;

		stdLib=new StdLib();
	}

	long RCALL AddRef()
	{
		ADD_REF_CODE
	}

	long RCALL Release()
	{
		RELEASE_CODE
	}	

	bool RCALL Init(RCOMSystemAPI *_systemAPI,bool isFinal)
	{
		systemAPI = _systemAPI;

		return true;
	}

	void RCALL Exec()
	{
		WNDCLASSW wc;
		ZeroMemory(&wc,sizeof(WNDCLASSW));
		wc.style                 = 0;
		wc.lpfnWndProc           = MainWndProc;
		wc.cbClsExtra            = 0;
		wc.cbWndExtra            = 0;
		wc.hInstance             = GetModuleHandleW(L"Plugin1.dll");
		wc.hIcon                 = 0;
		wc.hCursor               = LoadCursor((HINSTANCE)NULL, IDC_ARROW);
		wc.hbrBackground         = (HBRUSH)(COLOR_BTNFACE+1);
		wc.lpszMenuName          = NULL;
		wc.lpszClassName         = L"SIMPLE_WND_CLASS";
		RegisterClassW(&wc);
		pluginWindow=CreateWindowW(
			L"SIMPLE_WND_CLASS",
			L"Plugin Window",
			WS_OVERLAPPED|WS_SYSMENU,
			CW_USEDEFAULT, CW_USEDEFAULT,
			400, 200,
			NULL,
			NULL,
			wc.hInstance,
			NULL
			);

		ShowWindow(pluginWindow, SW_SHOW);
		UpdateWindow(pluginWindow);
		
	}

	RCOMObject* RCALL QueryObject(const GUID *clsID)
	{
		if(IsEqualGUID(*clsID,CLSID_STDLIB))
		{
			stdLib->AddRef();

			return (RCOMObject*)stdLib;
		}
		return 0;	
	}

	void RCALL Stop()
	{

	}

	void RCALL Quit()
	{
		DestroyWindow(pluginWindow);
		stdLib->Release();
	}

	const GUID* RCALL GetFactoryID()
	{
		return &CLSID_SIMPLE_FACTORY;
	}


};


extern "C" __declspec(dllexport) RCOMFactory* GetRCOMFactory(int index)
{
	if(index==0)
		return (RCOMFactory*)(new SimpleFactory());
	return 0;
}