

#include<windows.h>
#include"../rcom.h"
#include"KPointerList.h"
#include"PNewInstanceListener.h"

class FactoryHolder
{
public:
	RCOMFactory* factory;
	bool initOK;
};

class SystemAPI: public RCOMSystemAPI
{
protected:
	KPointerList<FactoryHolder*> *factoryList;
	volatile bool shutdownCalled;
	int nNumArgs;
	LPWSTR *args;
public:
	HWND baseWnd;
	PNewInstanceListener *newInstanceListener;
	
	bool RCALL IsFactoryAvailable(const GUID *factID);
	RCOMObject* RCALL GetObjectFromFactory(const GUID *factID,const GUID *clsID);
	bool RCALL ShutdownSystem();
	wchar_t* RCALL GetApplicationDir();
	int RCALL GetCommandlineArgCount();
	wchar_t* RCALL GetCommandlineArgument(int index);
	void RCALL SetNewInstanceListener(RCOMObject *newInstanceListener);
	RCOMObject* RCALL GetNewInstanceListener();

	void AddFactory(RCOMFactory *factory);
	void InitAll();
	void ExecAll();
	void StopAll();
	void QuitAll();
	void ReleaseAllFactories();	

	SystemAPI();
	~SystemAPI();
};