
#include"StdLib.h"
#include"StdLib_guid.h"

int StdLib::Add(int x,int y)
{
	return x+y;
}

void StdLib::SetText(RCOMString *text)
{
	MessageBoxW(0,text->GetString(),L"SetText Called with...",0);
}


StdLib::StdLib()
{
 	INITIALIZE_RCOM_OBJECT_PROPERTIES
}

StdLib::~StdLib() 
{
	RELEASE_RCOM_OBJECT_PROPERTIES	
}

int StdLib::GetInterfaceIndex(const GUID *interfaceID)
{
	if(IsEqualGUID(*interfaceID,IID_ISTDLIB))
		return 0;
	return UNSUPPORTED_INTERFACE;
}

int StdLib::_GetTypeInfo(int interfaceIndex, int methodID, int paramIndex)
{
	if(interfaceIndex==0)
	{
		if(methodID==IStdLib::ISTDLIB_ADD)
		{
			if(paramIndex == 0)
				return INT_TYPE;
			else if(paramIndex == 1)
				return INT_TYPE;
			else if(paramIndex == RETURN_TYPE_INDEX)
				return INT_TYPE;
			else
				return INVALID_PARAM;
		}else if(methodID==IStdLib::ISTDLIB_SET_TEXT)
		{
			if(paramIndex == 0)
				return STRING_TYPE;
			else if(paramIndex == RETURN_TYPE_INDEX)
				return VOID_TYPE;
			else
				return INVALID_PARAM;
		}
		if(parent)
			return parent->_GetTypeInfo(interfaceIndex, methodID, paramIndex);
		return UNSUPPORTED_METHOD;
	}
	if(parent)
		return parent->_GetTypeInfo(interfaceIndex, methodID, paramIndex);
	return UNSUPPORTED_INTERFACE;
}

int StdLib::_Invoke(int interfaceIndex, int methodID, void **params, int nparam, void *retval)
{
	if(interfaceIndex==0)
	{
		if(methodID==IStdLib::ISTDLIB_ADD)
		{
			cb(&StdLib::Add, retval, params);
			return DISPATCH_SUCCESS;
		}else if(methodID==IStdLib::ISTDLIB_SET_TEXT)
		{
			vcb(&StdLib::SetText, params);
			return DISPATCH_SUCCESS;
		}
		if(parent)
			return parent->_Invoke(interfaceIndex, methodID, params, nparam, retval);
		return UNSUPPORTED_METHOD;
	}
	if(parent)
		return parent->_Invoke(interfaceIndex, methodID, params, nparam, retval);
	return UNSUPPORTED_INTERFACE;	
}

#define RC_CLASS StdLib
	IMPLEMENTS_REFERENCE_COUNT
	IMPLEMENTS_GET_CLASS_ID(CLSID_STDLIB)
	IMPLEMENTS_OVERRIDE_INVOKE
	IMPLEMENTS_SET_PARENT
	REDIRECT_GET_TYPE_INFO
	REDIRECT_INVOKE
#undef RC_CLASS