
#include"config.h"
#include"RCOMLoader.h"
#include<windows.h>

SystemAPI *_sysAPI=0;

LRESULT CALLBACK MainWndProc(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam)
{
	switch ( message )
	{
	case WM_COPYDATA: // cmdline from another instance
		{
			PCOPYDATASTRUCT pCopyData = (PCOPYDATASTRUCT)lParam;

			int nNumArgs=0;
			LPWSTR *args;

			args=CommandLineToArgvW((const wchar_t*)pCopyData->lpData,&nNumArgs);
			if(nNumArgs>1)
			{
				if(_sysAPI)
				{
					if(_sysAPI->newInstanceListener)
					{
						RCOMString **strArgs=new RCOMString*[nNumArgs-1];
						for(int i=1;i<nNumArgs;i++)
							strArgs[i-1]=MakeString(args[i]);

						_sysAPI->newInstanceListener->OnNewInstanceStart(strArgs,nNumArgs-1);
						
						for(int j=0;j<nNumArgs-1;j++)
							strArgs[j]->Release();

						delete []strArgs;
					}
				}
			}

			LocalFree(args);
		}
		return TRUE;
	case WM_CLOSE:
		DestroyWindow(hwnd);
		return 0;
	case WM_DESTROY:
		PostQuitMessage(0);
		return 0;
	}
	return DefWindowProcW(hwnd, message, wParam, lParam);
}

void RCOMLoader::LoadComponent(wchar_t* path)
{
	UINT OldErrMode = SetErrorMode(SEM_FAILCRITICALERRORS); // prevents bad image error msg for data files!
	HMODULE hModule=LoadLibraryW(path);
	SetErrorMode (OldErrMode);
	if(hModule)
	{

		FARPROC entryPoint=GetProcAddress(hModule,"GetRCOMFactory");
		if(entryPoint) // valid component!
		{
			typedef RCOMFactory* (*GetRCOMFactory)(int);
			RCOMFactory* factory=((GetRCOMFactory)entryPoint)(0);
			if(factory)
			{
				dllList->AddPointer(hModule);
				int i=1;
				while(factory)
				{				
					systemAPI->AddFactory(factory);
					factory=((GetRCOMFactory)entryPoint)(i);
					i++;
				}
			}
			else
			{
				FreeLibrary(hModule);
			}
		}else
		{
			FreeLibrary(hModule);
		}

	}
}

void RCOMLoader::SearchDirForComponents(wchar_t* root_)
{
	wchar_t* buf=new wchar_t[MAX_PATH];
	wchar_t* root=new wchar_t[MAX_PATH];

	GetCurrentDirectoryW(MAX_PATH,buf);
	wcscpy(root,root_);

	if(SetCurrentDirectoryW(root)==0)
	{
		delete []root;
		delete []buf;
		return;
	}

	WIN32_FIND_DATAW current_file;
	HANDLE file_search=0;

	file_search = FindFirstFileW(L"*.*", &current_file);

	if (file_search == INVALID_HANDLE_VALUE)
	{
		delete []root;
		delete []buf;
		return;
	}

	do{
		if(current_file.dwFileAttributes==0xffffffff)
			continue;

		if( (!lstrcmpW(current_file.cFileName,L".")) || (!lstrcmpW(current_file.cFileName,L"..")))
		{
			continue;
		}

		if( (current_file.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)!=0 )
		{

			wchar_t* root2=new wchar_t[MAX_PATH];
			wcscpy(root2,root);

			if(root2[lstrlenW(root2)-1]!=L'\\')
			{
				wcscat(root2,L"\\");
			}
			wcscat(root2,current_file.cFileName);

			SearchDirForComponents(root2);
		}
		else
		{
			// root is dir & current_file.cFileName is filename			
			wchar_t filePath[MAX_PATH];
			wcscpy(filePath,root);

			if(filePath[lstrlenW(filePath)-1]!=L'\\')
			{
				wcscat(filePath,L"\\");
			}
			wcscat(filePath,current_file.cFileName);

			LoadComponent(filePath);
		}
	} while (FindNextFileW(file_search, &current_file));

	FindClose(file_search);

	SetCurrentDirectoryW(buf);
	delete []buf;
	delete []root;

}

void RCOMLoader::LoadAndRunComponents()
{
	// create basewnd
	WNDCLASSW wc;
	ZeroMemory(&wc,sizeof(WNDCLASSW));
	wc.style                 = 0;
	wc.lpfnWndProc           = MainWndProc;
	wc.cbClsExtra            = 0;
	wc.cbWndExtra            = 0;
	wc.hInstance             = GetModuleHandleW(0);
	wc.hIcon                 = 0;
	wc.hCursor               = LoadCursor((HINSTANCE)NULL, IDC_ARROW);
	wc.hbrBackground         = (HBRUSH)GetStockObject(WHITE_BRUSH);
	wc.lpszMenuName          = NULL;
	wc.lpszClassName         = BASE_WND_CLASS;
	RegisterClassW(&wc);
	HWND baseWnd=CreateWindowW(
		BASE_WND_CLASS,
		APP_GUID,
		WS_OVERLAPPED|WS_SYSMENU,
		CW_USEDEFAULT, CW_USEDEFAULT,
		400, 200,
		NULL,
		NULL,
		wc.hInstance,
		NULL
		);

	//ShowWindow(baseWnd, SW_SHOW);
	//UpdateWindow(baseWnd);


	// create systemAPI
	systemAPI=new SystemAPI();
	_sysAPI=systemAPI;

	// set basewnd of systemAPI
	systemAPI->baseWnd=baseWnd;

	// search components & load
	dllList=new KPointerList<HMODULE>();
	wchar_t buff[MAX_PATH];
	wcscpy(buff,systemAPI->GetApplicationDir());
	wcscat(buff,L"\\plugins");
	
	SearchDirForComponents(buff);

	// call init
	systemAPI->InitAll();

	// call exec
	systemAPI->ExecAll();

	// run message loop
	MSG msg;
	while ( GetMessage(&msg, NULL, 0, 0) )
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}

	systemAPI->StopAll();
	systemAPI->QuitAll();

	// free resources
	systemAPI->ReleaseAllFactories(); // this will call destructor of factories
	delete systemAPI; // delete systemAPI

	// unload dll files
	for(int i=0;i<dllList->GetSize();i++)
		FreeLibrary(dllList->GetPointer(i));
	delete dllList;

}