#include <string.h>
#include "tinyxml.h"

class XmlElement
{
	TiXmlElement* pElem;

public:
	XmlElement(TiXmlElement* pElem)
	{
		this->pElem = pElem;
	}

	const char* getTagName()
	{
		return pElem->Value();
	}

	XmlElement* getFirstChildElement()
	{
		TiXmlElement* res = pElem->FirstChildElement();
		
		if(res)
			return new XmlElement(res);

		return 0;
	}

	XmlElement* getNextElement()
	{
		TiXmlElement* res = pElem->NextSiblingElement();

		if(res)
			return new XmlElement(res);

		return 0;
	}

	const char* getText()
	{
		return pElem->GetText();
	}

	const char* getStringAttributeValue(const char* attributeName)
	{
		return pElem->Attribute(attributeName);
	}

	int getIntAttributeValue(const char* attributeName, int defVal)
	{
		pElem->QueryIntAttribute(attributeName, &defVal);
		return defVal;
	}

	int getNumAttributes()
	{
		TiXmlAttribute* pAttrib = pElem->FirstAttribute();

		if(pAttrib)
		{
			int i = 0;
			while(pAttrib)
			{
				++i;
				pAttrib = pAttrib->Next();
			}
			return i;
		}

		return 0;
	}

	const char* getAttributeName(int attributeIndex)
	{
		TiXmlAttribute* pAttrib = pElem->FirstAttribute();

		if(pAttrib)
		{
			int i = 0;
			while(pAttrib)
			{
				if(i == attributeIndex)
					return pAttrib->Name();

				++i;
				pAttrib = pAttrib->Next();
			}
		}

		return 0;
	}

	bool hasAttribute(const char* attributeName) 
	{
		TiXmlAttribute* pAttrib = pElem->FirstAttribute();

		if(pAttrib)
		{
			while(pAttrib)
			{
				if(strcmp(pAttrib->Name(), attributeName) == 0)
					return true;

				pAttrib = pAttrib->Next();
			}
		}
		return false;
	}
};

class XmlParser
{
	TiXmlDocument* doc;
	bool success;

public:
	XmlParser(const char* filePath)
	{
		doc = new TiXmlDocument(filePath);
		success = doc->LoadFile();
	}

	~XmlParser()
	{
		delete doc;
	}
	
	XmlElement* getFirstElement()
	{
		if(!success)
			return 0;

		TiXmlElement* pElem = doc->FirstChildElement();
		
		if(pElem)
			return new XmlElement(pElem);

		return 0;
	}

	static XmlElement* parseString(const char* buffer)
	{
		return 0;
	}
};

int main()
{
	XmlParser* parser = new XmlParser("main.xml");
	
	XmlElement* rootElement = parser->getFirstElement();
	
	if(rootElement->getFirstChildElement()->hasAttribute("title"))
		printf("fsdfsdfs");

	delete rootElement;
	delete parser;

	return 0;
}
