#ifndef _PXML_PARSER_H_
#define _PXML_PARSER_H_

#include "../rcom.h"
#include "XmlFactory_guid.h"
#include "XmlParser_guid.h"
#include "IXmlParser.h"
#include "PXmlElement.h"

class PXmlParser: public ClientHelper
{
protected:
	RCOMObject *obj;
	int interfaceIndex;

public:

	PXmlParser()
	{
		obj=0;
	}

	~PXmlParser()
	{
		if(obj)
			obj->Release();
	}

	bool AcquireRCOMObject(RCOMSystemAPI *systemAPI)
	{
		if(obj)
			obj->Release();

		obj=systemAPI->GetObjectFromFactory(&CLSID_XML_FACTORY, &CLSID_XML_PARSER);
		if(obj)
		{
			interfaceIndex=obj->GetInterfaceIndex(&IID_IXML_PARSER);
			if(interfaceIndex!=UNSUPPORTED_INTERFACE)
				return true;

			obj->Release();
			obj=0;
		}
		return false;
	}

	PXmlElement* InitUsingFile(const char* filePath)
	{
		RCOMObject* retVal=0;
		RCOMString* strFilePath = MakeString(filePath);

		_call(obj, interfaceIndex, IXmlParser::IXMLPARSER_INIT_USING_FILE, strFilePath, &retVal);

		if(strFilePath)
			strFilePath->Release();

		if(retVal)
			return new PXmlElement(retVal);
		
		return 0;
	}

};

#endif
