
include('js/common/rcom.js');
include('js/common/socket.js');

function URLReader()
{
	var parent;

	this.ReadURL=function(url)
	{
		var s = Socket.connect(url, 80);
		if(s)
		{
			s.send("GET / HTTP/1.0\n\n");
			return s.recv();
		}
		return null;
	}

	this.GetInterfaceIndex=function(interfaceID)
	{
		if(interfaceID.toUpperCase()==IID_IHTTP_READER.toUpperCase())
			return 0;
		return UNSUPPORTED_INTERFACE;
	}

	this._GetTypeInfo=function(interfaceIndex, methodID, paramIndex)
	{
		if(interfaceIndex==0)
		{
			if(methodID==IHTTPREADER_READ_URL)
			{
				if(paramIndex == 0)
					return STRING_TYPE;
				else if(paramIndex == RETURN_TYPE_INDEX)
					return STRING_TYPE;
				else
					return INVALID_PARAM;
			}
			if(this.parent)
				return this.parent._GetTypeInfo(interfaceIndex, methodID, paramIndex);
			return UNSUPPORTED_METHOD;
		}
		if(this.parent)
			return this.parent._GetTypeInfo(interfaceIndex, methodID, paramIndex);
		return UNSUPPORTED_INTERFACE;
	}

	this._Invoke=function(msg)
	{
		if(msg.interfaceIndex==0)
		{
			if(msg.methodID==IHTTPREADER_READ_URL)
			{
				msg.retVal=this.ReadURL(msg.params[0]);		
				return DISPATCH_SUCCESS;
			}

			if(this.parent)
				return this.parent._Invoke(msg);
			return UNSUPPORTED_METHOD;
		}
		if(this.parent)
			return this.parent._Invoke(msg);
		return UNSUPPORTED_INTERFACE;		
	}

	this.GetClassID=function()
	{
		return CLSID_URL_READER;
	}

}

function SocketFactory()
{ 
	var systemAPI;

	this.GetFactoryID=function()
	{
		return CLSID_SOCKET_FACTORY;
	}

	this.Init=function(systemAPI,isFinal)
	{
		this.systemAPI=systemAPI;

		return true;
	}

	this.Exec=function()
	{

	}

	this.QueryObject=function(clsID)
	{
		if(clsID.toUpperCase()==CLSID_URL_READER.toUpperCase())
		{
			var urlReader = new URLReader();
			if(convertToRCOMObject(urlReader))
			{
				return urlReader;
			}else
			{
				print('cannot convert url reader to rcom object');
			}
		}

		return null;	
	}

	this.Stop=function()
	{

	}

	this.Quit=function()
	{

	}

}


function GetRCOMFactory()
{
	return new SocketFactory();
}