
// Xml Parser Proxy for JS 
// by R.Hasaranga (c) 2018

var CLSID_XML_FACTORY = '1798a074-bf43-4a3b-85b7-5d112fbaa3ec';
var CLSID_XML_PARSER = '1798a073-bf43-4a3b-85b7-5d112fbaa3ec';
var IID_IXML_PARSER = '1798a071-bf43-4a3b-85b7-5d112fbaa3ec';
var IID_IXML_ELEMENT = '1798a072-bf43-4a3b-85b7-5d112fbaa3ec';

// method ids of IXmlParser interface
var IXMLPARSER_INIT_USING_FILE = 10;

// method ids of IXmlElement interface
var IXMLELEMENT_GET_TAG_NAME=10;
var IXMLELEMENT_GET_FIRST_CHILD_ELEMENT=11;
var IXMLELEMENT_GET_NEXT_ELEMENT=12;
var IXMLELEMENT_GET_TEXT=13;
var IXMLELEMENT_GET_STRING_ATTR_VALUE=14;
var IXMLELEMENT_GET_INT_ATTR_VALUE=15;
var IXMLELEMENT_GET_NUM_ATTR=16;
var IXMLELEMENT_GET_ATTR_NAME=17;
var IXMLELEMENT_HAS_ATTRIBUTE=18;


// proxy for XmlElement class
function PXmlElement()
{
	var obj;
	var interfaceIndex;

	this.Init=function(obj)
	{
		this.obj=obj;

		if(this.obj)
		{
			this.interfaceIndex=this.obj.GetInterfaceIndex(IID_IXML_ELEMENT);
			return true;
		}

		return false;
	}

	this.Release=function()
	{
		if(this.obj)
			this.obj.Release();
	}

	this.GetTagName=function()
	{
		var params=[];
		var msg={'interfaceIndex':this.interfaceIndex, 'methodID':IXMLELEMENT_GET_TAG_NAME, 'params':params};
		
		this.obj.Invoke(msg);

		return msg.retVal;
	}

	this.GetFirstChildElement=function()
	{
		var params=[];
		var msg={'interfaceIndex':this.interfaceIndex, 'methodID':IXMLELEMENT_GET_FIRST_CHILD_ELEMENT, 'params':params};
		
		this.obj.Invoke(msg);

		if(msg.retVal)
		{
			var element = new PXmlElement();
			element.Init(msg.retVal);
			return element;
		}
		return null;
	}

	this.GetNextElement=function()
	{
		var params=[];
		var msg={'interfaceIndex':this.interfaceIndex, 'methodID':IXMLELEMENT_GET_NEXT_ELEMENT, 'params':params};
		
		this.obj.Invoke(msg);

		if(msg.retVal)
		{
			var element = new PXmlElement();
			element.Init(msg.retVal);
			return element;
		}
		return null;
	}

	this.GetText=function()
	{
		var params=[];
		var msg={'interfaceIndex':this.interfaceIndex, 'methodID':IXMLELEMENT_GET_TEXT, 'params':params};
		
		this.obj.Invoke(msg);

		return msg.retVal;
	}

	this.GetStringAttributeValue=function(attributeName)
	{
		var params=[attributeName];
		var msg={'interfaceIndex':this.interfaceIndex, 'methodID':IXMLELEMENT_GET_STRING_ATTR_VALUE, 'params':params};
		
		this.obj.Invoke(msg);

		return msg.retVal;
	}

	this.GetIntAttributeValue=function(attributeName, defVal)
	{
		var params=[attributeName, defVal];
		var msg={'interfaceIndex':this.interfaceIndex, 'methodID':IXMLELEMENT_GET_INT_ATTR_VALUE, 'params':params};
		
		this.obj.Invoke(msg);

		return msg.retVal;
	}

	this.GetNumAttributes=function()
	{
		var params=[];
		var msg={'interfaceIndex':this.interfaceIndex, 'methodID':IXMLELEMENT_GET_NUM_ATTR, 'params':params};
		
		this.obj.Invoke(msg);

		return msg.retVal;
	}

	this.GetAttributeName=function(attributeIndex)
	{
		var params=[attributeIndex];
		var msg={'interfaceIndex':this.interfaceIndex, 'methodID':IXMLELEMENT_GET_ATTR_NAME, 'params':params};
		
		this.obj.Invoke(msg);

		return msg.retVal;
	}

	this.HasAttribute=function(attributeName)
	{
		var params=[attributeName];
		var msg={'interfaceIndex':this.interfaceIndex, 'methodID':IXMLELEMENT_HAS_ATTRIBUTE, 'params':params};
		
		this.obj.Invoke(msg);

		return msg.retVal;
	}
}

// proxy for XmlParser class
function PXmlParser()
{
	var obj;
	var interfaceIndex;

	this.AcquireObject=function(systemAPI)
	{
		this.obj=systemAPI.GetObjectFromFactory(CLSID_XML_FACTORY, CLSID_XML_PARSER);
		if(this.obj)
		{
			this.interfaceIndex=this.obj.GetInterfaceIndex(IID_IXML_PARSER);
			return true;
		}
		return false;
	}

	this.Release=function()
	{
		if(this.obj)
			this.obj.Release();
	}

	this.InitUsingFile=function(file)
	{
		var params=[file];
		var msg={'interfaceIndex':this.interfaceIndex, 'methodID':IXMLPARSER_INIT_USING_FILE, 'params':params};
		
		this.obj.Invoke(msg);

		if(msg.retVal)
		{
			var element = new PXmlElement();
			element.Init(msg.retVal);
			return element;
		}
		return null;
	}
}

