
#include "config.h"
#include "RCOMLoader.h"
#include <string.h>

#ifdef ENABLE_GTK
	#include <gtk/gtk.h>
#endif

#ifdef WIN32
	#define LOAD_LIBRARY(FILE_NAME) LoadLibraryA(FILE_NAME)
	#define GET_LIB_FUNCTION(LIB_HANDLE,FUNC_NAME) GetProcAddress(LIB_HANDLE,FUNC_NAME)
	#define UNLOAD_LIBRARY(LIB_HANDLE) FreeLibrary(LIB_HANDLE)
#else
	#include <dlfcn.h>
	#include <dirent.h>
	#include <unistd.h>
	#include <sys/stat.h>
	#define LOAD_LIBRARY(FILE_NAME) dlopen(FILE_NAME,RTLD_LAZY)
	#define GET_LIB_FUNCTION(LIB_HANDLE,FUNC_NAME) dlsym(LIB_HANDLE,FUNC_NAME)
	#define UNLOAD_LIBRARY(LIB_HANDLE) dlclose(LIB_HANDLE)
#endif

#ifdef ENABLE_TRACE
	#define TRACE(TEXT) printf(TEXT);
	#define TRACELN(TEXT) printf("%s\n",TEXT);
	#define TRACE_PARAM(TEXT,PARAM) printf(TEXT,PARAM);
#else
	#define TRACE(TEXT) 
	#define TRACELN(TEXT) 
	#define TRACE_PARAM(TEXT,PARAM) 
#endif


bool RCOMLoader::LoadComponent(char* path, bool runComponent)
{
	TRACE_PARAM("loading: %s\n", path)

	void* hModule = LOAD_LIBRARY(path);

	if(hModule)
	{
		void* entryPoint = GET_LIB_FUNCTION(hModule, "GetRCOMFactory");
		if(entryPoint) // valid component!
		{	
			typedef RCOMFactory* (*GetRCOMFactory)(int);
			RCOMFactory* factory = ((GetRCOMFactory)entryPoint)(0);
			if(factory)
			{
				dllList->AddPointer(hModule);
				int i = 1;
				while(factory)
				{	
					TRACE_PARAM("acquiring factory - %d\n", i-1)			
					systemAPI->AddFactory(factory, runComponent);				
					factory = ((GetRCOMFactory)entryPoint)(i);
					i++;
				}
				return true;
			}
			else
			{
				UNLOAD_LIBRARY(hModule);TRACELN("");
				TRACELN("acquiring factory - 0\nerror: zero factories")
			}
		}else
		{
			UNLOAD_LIBRARY(hModule);
			TRACELN("error: missing entry point")
		}
	}
	else
	{
		TRACELN("error: library load failed")
	}
	return false;
}

#ifdef WIN32 // windows

void RCOMLoader::SearchDirForComponents(char* root_)
{
	char* buf=new char[512];
	char* root=new char[512];

	GetCurrentDirectoryA(512, buf);
	strcpy(root, root_);

	if(SetCurrentDirectoryA(root) == 0)
	{
		delete []root;
		delete []buf;
		return;
	}

	WIN32_FIND_DATAA current_file;
	HANDLE file_search = 0;

	file_search = FindFirstFileA("*.dll", &current_file);

	if (file_search == INVALID_HANDLE_VALUE)
	{
		delete []root;
		delete []buf;
		return;
	}

	do{
		if(current_file.dwFileAttributes == 0xffffffff)
			continue;

		if( (!lstrcmpA(current_file.cFileName, ".")) || (!lstrcmpA(current_file.cFileName, "..")))
		{
			continue;
		}

		if( (current_file.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) != 0 )
		{
			char* root2 = new char[512];
			strcpy(root2, root);

			if(root2[lstrlenA(root2)-1] != '\\')
			{
				strcat(root2, "\\");
			}
			strcat(root2, current_file.cFileName);

			SearchDirForComponents(root2);
		}
		else
		{
			// root is dir & current_file.cFileName is filename			
			char filePath[512];
			strcpy(filePath, root);

			if(filePath[lstrlenA(filePath)-1] != '\\')
			{
				strcat(filePath, "\\");
			}
			strcat(filePath, current_file.cFileName);

			LoadComponent(filePath);
		}
	} while (FindNextFileA(file_search, &current_file));

	FindClose(file_search);

	SetCurrentDirectoryA(buf);
	delete []buf;
	delete []root;

}

#else // linux

void RCOMLoader::SearchDirForComponents(char* dir)
{
	// http://www.johnloomis.org/ece537/notes/Files/Examples/printdir.html

    DIR *dp;
    struct dirent *entry;
    struct stat statbuf;

    if((dp = opendir(dir)) == NULL)
        return;

    chdir(dir);
    while((entry = readdir(dp)) != NULL) 
	{
        lstat(entry->d_name,&statbuf);

        if(S_ISDIR(statbuf.st_mode))
		{
            /* Found a directory, but ignore . and .. */
            if( (strcmp(".",entry->d_name) == 0) || (strcmp("..",entry->d_name) == 0) )
                continue;

            /* Recurse at a new indent level */
            SearchDirForComponents(entry->d_name);
        }
        else
		{
			int size = strlen(entry->d_name);
			if( ( size > 3 ) && (strcmp(&entry->d_name[size - 3], ".so") == 0) )
			{
				char filePath[512];
				getcwd(filePath, 512);
				strcat(filePath, "/");
				strcat(filePath, entry->d_name);
				LoadComponent(filePath);
			}
		}
    }

    chdir("..");
    closedir(dp);
}

#endif

void RCOMLoader::LoadAndRunComponents(int argc, char* argv[])
{
	TRACELN("initialzing RCOM...")

	// create systemAPI
	systemAPI = new SystemAPI(argc, argv, this);

	// search components & load
	dllList = new KPointerList<DLL_TYPE>();
	char buff[512];
	strcpy(buff, systemAPI->GetApplicationDir());

#ifdef WIN32 // windows
	strcat(buff, "\\plugins");
#else // linux
	strcat(buff, "/plugins");
#endif
	
	TRACELN("scanning for plugins...")
	SearchDirForComponents(buff);

	// call init
	TRACELN("calling init...")
	systemAPI->InitAll();

	// call exec
	TRACELN("calling exec...")
	systemAPI->ExecAll();

#ifdef ENABLE_GTK
	gtk_main ();
#endif		

	TRACELN("shutting down...\ncalling stop...")
	systemAPI->StopAll();
	TRACELN("calling quit...")
	systemAPI->QuitAll();

	TRACELN("freeing resources...")

	// free resources
	systemAPI->ReleaseAllFactories(); // this will call destructor of factories
	delete systemAPI; // delete systemAPI

	// unload dll files
	for(int i = 0; i < dllList->GetSize(); i++)
	{
		UNLOAD_LIBRARY(dllList->GetPointer(i));
	}

	delete dllList;

}

