
#include <stdlib.h>
#include <string.h>
#include <uuid/uuid.h>
#include <stdio.h>

	typedef struct _GUID {
	  unsigned int Data1;
	  unsigned short Data2;
	  unsigned short Data3;
	  unsigned char Data4[8];
	} GUID;

	bool inline IsEqualGUID(const GUID &rguid1, const GUID &rguid2)
	{
		return memcmp(&rguid1, &rguid2, sizeof(GUID)) == 0;
	}

void ByteSwapGUID(GUID *guid)
{
	// byte swapping = little endian <-> big endian

	guid->Data1 = __builtin_bswap32(guid->Data1);
	guid->Data2 = ( (guid->Data2 & 0xFF) << 8 ) | ( (guid->Data2 & 0xFF00) >> 8 );
	guid->Data3 = ( (guid->Data3 & 0xFF) << 8 ) | ( (guid->Data3 & 0xFF00) >> 8 );
}

int UuidFromStringA(const char* text, GUID *guid)
{
	int retVal = uuid_parse(text, (unsigned char*)guid);
	ByteSwapGUID(guid); // convert to microsoft guid
	return retVal;
}

void UuidToStringA(GUID* guid, char** text)
{
	GUID linGUID;
	memcpy(&linGUID, guid, sizeof(GUID)); // make a copy of it

	ByteSwapGUID(&linGUID); // convert to linux uuid

	char *buffer = (char*)malloc(37);
	uuid_unparse((unsigned char*)&linGUID, buffer);
	*text = buffer;
}

void RpcStringFreeA(char** text)
{
	free(*text);
}

// {1798A074-BF43-4a3b-85B7-5D112FBAA3EC}
GUID CLSID_XML_FACTORY = { 0x1798a074, 0xbf43, 0x4a3b, { 0x85, 0xb7, 0x5d, 0x11, 0x2f, 0xba, 0xa3, 0xec } };

const char * str_CLSID_XML_FACTORY = "1798A074-BF43-4A3B-85B7-5D112FBAA3EC";

int main()
{
	GUID guid;
	if(UuidFromStringA(str_CLSID_XML_FACTORY, &guid) == 0)
	{
		if(IsEqualGUID(guid, CLSID_XML_FACTORY))
			printf("equal");
		else
			printf("not equal");

		char *buffer;
		UuidToStringA(&CLSID_XML_FACTORY, &buffer);
		printf("\nguid: %s\n", buffer);
		RpcStringFreeA(&buffer);
	}
	else
	{
		printf("conversion failed");
	}
	return 0;
}

