
#include <gtk/gtk.h>
#include "../rcom.h"

// {D3B85E84-5C60-4f6d-8594-870F5F6C92F0}
static const GUID CLSID_MyFactory = { 0xd3b85e84, 0x5c60, 0x4f6d, { 0x85, 0x94, 0x87, 0xf, 0x5f, 0x6c, 0x92, 0xf0 } };


RCOMSystemAPI *systemAPI;

GtkWidget *window;

static gboolean delete_event(GtkWidget *widget, GdkEvent *event, gpointer data)
{
    return FALSE;
}

static void destroy(GtkWidget *widget, gpointer data)
{
    systemAPI->ShutdownSystem();
}

class MyFactory : public RCOMFactory
{
protected:
	long refCount;

public:

	MyFactory()
	{
		refCount=1;
	}

	long RCALL AddRef()
	{
		ADD_REF_CODE
	}

	long RCALL Release()
	{
		RELEASE_CODE
	}	

	bool RCALL Init(RCOMSystemAPI *_systemAPI,bool isFinal)
	{
		systemAPI = _systemAPI;

		return true;
	}

	void RCALL Exec()
	{
		window = gtk_window_new (GTK_WINDOW_TOPLEVEL);

		gtk_container_set_border_width (GTK_CONTAINER (window), 10);
		gtk_widget_set_size_request (window, 400, 200);
		gtk_window_set_title (GTK_WINDOW (window), "Plugin Window");

		g_signal_connect(window, "delete-event", G_CALLBACK(delete_event), NULL);
    	g_signal_connect (window, "destroy", G_CALLBACK(destroy), NULL);

		gtk_widget_show(window); 
	}

	RCOMObject* RCALL QueryObject(const GUID *clsID)
	{
		return 0;	
	}

	void RCALL Stop()
	{

	}

	void RCALL Quit()
	{
		
	}

	const GUID* RCALL GetFactoryID()
	{
		return &CLSID_MyFactory;
	}


};


RCOM_LIB_EXPORT RCOMFactory* GetRCOMFactory(int index)
{
	if(index==0)
		return (RCOMFactory*)(new MyFactory());
	return 0;
}

