
#ifndef _IXMLELEMENT_H_
#define _IXMLELEMENT_H_

#include"../rcom.h"

// {1798A072-BF43-4a3b-85B7-5D112FBAA3EC}
static const GUID IID_IXML_ELEMENT = { 0x1798a072, 0xbf43, 0x4a3b, { 0x85, 0xb7, 0x5d, 0x11, 0x2f, 0xba, 0xa3, 0xec } };

struct IXmlElement
{
	enum {
    	IXMLELEMENT_GET_TAG_NAME=10,
    	IXMLELEMENT_GET_FIRST_CHILD_ELEMENT=11,
    	IXMLELEMENT_GET_NEXT_ELEMENT=12,
    	IXMLELEMENT_GET_TEXT=13,
    	IXMLELEMENT_GET_STRING_ATTR_VALUE=14,
    	IXMLELEMENT_GET_INT_ATTR_VALUE=15,
    	IXMLELEMENT_GET_NUM_ATTR=16,
    	IXMLELEMENT_GET_ATTR_NAME=17,
    	IXMLELEMENT_HAS_ATTRIBUTE=18,		
  	};

	virtual RCOMString* GetTagName()=0;
	virtual RCOMObject* GetFirstChildElement()=0;
	virtual RCOMObject* GetNextElement()=0;
	virtual RCOMString* GetText()=0;
	virtual RCOMString* GetStringAttributeValue(RCOMString* attributeName)=0;
	virtual int GetIntAttributeValue(RCOMString* attributeName, int defVal)=0;
	virtual int GetNumAttributes()=0;
	virtual RCOMString* GetAttributeName(int attributeIndex)=0;
	virtual bool HasAttribute(RCOMString* attributeName)=0;
};

#endif
