
// select arduino Pro Mini
// when flashing: hold reset button untill "Sketch uses 1012 bytes..." shows



#define LED 13
#define OUT_PIN 12

#define ON_TIME_SECS 32
#define INTERVAL_MINS 15


void setup() {                
  // initialize the digital pin as an output.
  pinMode(LED, OUTPUT);  
  pinMode(OUT_PIN, OUTPUT);    
}

void DelaySec(unsigned char secs)
{
  for(int i=0;i<secs;i++)
  {
    delay(1000);
  }
}

void DelayMin(unsigned char mins)
{
  for(int i=0;i<mins;i++)
  {
    DelaySec(60);
  } 
}

// the loop routine runs over and over again forever:
void loop() {
   
  digitalWrite(LED, HIGH);   // turn the LED on (HIGH is the voltage level)
  digitalWrite(OUT_PIN, HIGH);
  DelaySec(ON_TIME_SECS);  // wait 10 secs
  digitalWrite(LED, LOW);    // turn the LED off by making the voltage LOW
  digitalWrite(OUT_PIN, LOW);
  
  while(true)
  {
    DelayMin(INTERVAL_MINS);
    digitalWrite(LED, HIGH);
    digitalWrite(OUT_PIN, HIGH);
    DelaySec(ON_TIME_SECS); 
    digitalWrite(LED, LOW);
    digitalWrite(OUT_PIN, LOW);
  }
}
