
#include <avr/sleep.h>    // Sleep Modes
#include <avr/power.h>

int speakerPin = 4;
int sensorPin = 0;

void beep()
{
  for(int i=0;i<100;i++)
  {
    digitalWrite(speakerPin, HIGH); 
    delay(2); 
    digitalWrite(speakerPin, LOW); 
    delay(2); 
  } 
 
  digitalWrite(speakerPin, LOW);  
}

void setup() {                
  pinMode(speakerPin, OUTPUT);
  pinMode(sensorPin, INPUT); 
  
  digitalWrite(speakerPin, LOW); 
  
  PCMSK  |= bit (PCINT0);  // want pin 0
  GIFR   |= bit (PCIF);    // clear any outstanding interrupts
  GIMSK  |= bit (PCIE);    // enable pin change interrupts 
}

ISR (PCINT0_vect) 
{ 
}

void loop() {
  
  goToSleep();
  
  //beep();
 
  if(digitalRead(sensorPin)==1) // pin changed from low to high
  {
    beep();
  }  
  
}

void goToSleep ()
{
    ADCSRA &= ~(1<<ADEN); //Disable ADC, saves ~230uA
    
    set_sleep_mode(SLEEP_MODE_PWR_DOWN); // sleep mode is set here
    sleep_enable();
    sleep_mode();                        // System actually sleeps here
    sleep_disable();                     // System continues execution here when interrupt occur 
}
