
#include"oui.h"
#include<windows.h>

static int cld_mouse_x;
static int cld_mouse_y;

static int cld_captured;

static void (__stdcall *setLayeredWindowAttributes)(HWND, int, int, int);


void setAlpha(HWND hwnd, int alpha){

	static const int WS_EX_LAYERED=0x80000;

    SetWindowLong(hwnd, GWL_EXSTYLE, GetWindowLong(hwnd, GWL_EXSTYLE) & ~WS_EX_LAYERED);
    SetWindowLong(hwnd, GWL_EXSTYLE, GetWindowLong(hwnd, GWL_EXSTYLE) | WS_EX_LAYERED);

	setLayeredWindowAttributes=(void (__stdcall *)(HWND,int,int,int))GetProcAddress(LoadLibraryA("USER32.DLL") ,"SetLayeredWindowAttributes");
	(*setLayeredWindowAttributes)(hwnd, 0, alpha, 2); 

}

void EnableClientAreaDrag(HWND hWindow, UINT msg, WPARAM wParam,LPARAM lParam)
{
	int frameSZ,titleSZ;

	RECT cRect,wRect;
	POINT pos;

	switch (msg)
	{

		case WM_MOUSEMOVE:
			if (!cld_captured) break;
			GetCursorPos(&pos);
			SetWindowPos(hWindow, NULL,pos.x-cld_mouse_x,pos.y-cld_mouse_y , 0, 0,SWP_NOSIZE | SWP_NOZORDER);
			break; 

		case WM_LBUTTONDOWN:
			cld_captured = 1;
			SetCapture(hWindow);
	  
			GetClientRect(hWindow,&cRect);
			GetWindowRect(hWindow,&wRect);

			frameSZ=((wRect.right-cRect.right)-wRect.left)/2;
			titleSZ=(wRect.bottom-cRect.bottom)-wRect.top;

			cld_mouse_x = LOWORD(lParam)+frameSZ;
			cld_mouse_y = HIWORD(lParam)-frameSZ+titleSZ;
			break;

		case WM_LBUTTONUP:
			cld_captured = 0;
			ReleaseCapture();
			break;
	}

}

void RemoveDragRectangle(HWND hWindow, UINT msg, WPARAM wParam,LPARAM lParam){

	LPRECT lprc;

	switch (msg)
	{
		case WM_SIZING:
			lprc = (LPRECT) lParam;
			SetWindowPos(hWindow,0,0,0,lprc->right-lprc->left,lprc->bottom-lprc->top,SWP_NOMOVE);
			break;

		case WM_MOVING :
			lprc = (LPRECT) lParam;
			SetWindowPos(hWindow,0,lprc->left,lprc->top,0,0,SWP_NOSIZE);
			break;
	}
}

void SetMinimumSize(HWND hWindow, UINT msg, WPARAM wParam,LPARAM lParam,int minwidth,int minheight){

	if(msg==WM_SIZING){

		LPRECT lprc;
		lprc = (LPRECT) lParam;

		if((lprc->right-lprc->left)<minwidth){
			lprc->right=lprc->left+minwidth;
		}
		if((lprc->bottom-lprc->top)<minheight){
			lprc->bottom=lprc->top+minheight;
		}
	}
}

void SetMaximumSize(HWND hWindow, UINT msg, WPARAM wParam,LPARAM lParam,int maxwidth,int maxheight){

	if(msg==WM_SIZING){

		LPRECT lprc;
		lprc = (LPRECT) lParam;

		if((lprc->right-lprc->left)>maxwidth){
			lprc->right=lprc->left+maxwidth;
		}
		if((lprc->bottom-lprc->top)>maxheight){
			lprc->bottom=lprc->top+maxheight;
		}
	}
}

void EnableDocking(HWND hWindow, UINT msg, WPARAM wParam,LPARAM lParam,int distance){


	if(msg==WM_WINDOWPOSCHANGING)
	{

		LPWINDOWPOS lpwndpos=(LPWINDOWPOS)lParam;

		RECT	wndRect, trayRect;

		int		leftTaskbar = 0, rightTaskbar = 0, topTaskbar = 0, bottomTaskbar = 0;

		GetWindowRect(hWindow,&wndRect);


		// Screen resolution
		int screenWidth =	GetSystemMetrics(SM_CXSCREEN); 
		int screenHeight =	GetSystemMetrics(SM_CYSCREEN);

		// Find the taskbar
		HWND pWnd = FindWindowA("Shell_TrayWnd", "");

		GetWindowRect(pWnd,&trayRect);

		int wndWidth = wndRect.right - wndRect.left;
		int wndHeight = wndRect.bottom - wndRect.top;

		if(trayRect.top <= 0 && trayRect.left <= 0 && trayRect.right >= screenWidth) {
			// top taskbar
			topTaskbar = trayRect.bottom - trayRect.top;
		}
		else if(trayRect.top > 0 && trayRect.left <= 0) {
			// bottom taskbar
			bottomTaskbar = trayRect.bottom - trayRect.top;
		}
		else if(trayRect.top <= 0 && trayRect.left > 0) {
			// right taskbar
			rightTaskbar = trayRect.right - trayRect.left;
		}
		else {
			// left taskbar
			leftTaskbar = trayRect.right - trayRect.left;
		}

		// Snap to screen border
		// Left border
		if(lpwndpos->x >= -distance + leftTaskbar && lpwndpos->x <= leftTaskbar + distance) {
			lpwndpos->x = leftTaskbar;
		}

		// Top border
		if(lpwndpos->y >= -distance && lpwndpos->y <= topTaskbar + distance) {
			lpwndpos->y = topTaskbar;
		}

		// Right border
		if(lpwndpos->x + wndWidth <= screenWidth - rightTaskbar + distance && lpwndpos->x + wndWidth >= screenWidth - rightTaskbar - distance) {
			lpwndpos->x = screenWidth - rightTaskbar - wndWidth;
		}

		// Bottom border
		if( lpwndpos->y + wndHeight <= screenHeight - bottomTaskbar + distance && lpwndpos->y + wndHeight >= screenHeight - bottomTaskbar - distance) {
			lpwndpos->y = screenHeight - bottomTaskbar - wndHeight;
		}
	}

}