
;--------------------------------
;Include Modern UI

  !include "MUI.nsh"
  !include Library.nsh ; for lib uninstallation
;--------------------------------
;Configuration

  ;General
name "StopIt v1.0"; Name of the installer
outfile "StopIt v1.0 setup.exe" ; installer name

  ;Default installation folder
installdir "$PROGRAMFILES\StopIt"
  
  ;Get installation folder from registry if available
  InstallDirRegKey HKCU "Software\StopIt" ""

CRCCheck on ; check the installer is damaged
XPStyle on ; add xp manifest to installer

;--------------------------------
;Interface Settings

  !define MUI_ABORTWARNING

;--------------------------------
;Pages

  !insertmacro MUI_PAGE_WELCOME
  !insertmacro MUI_PAGE_LICENSE "License.txt"
  !insertmacro MUI_PAGE_INSTFILES
  !insertmacro MUI_PAGE_FINISH
  
  !insertmacro MUI_UNPAGE_WELCOME
  !insertmacro MUI_UNPAGE_CONFIRM
  !insertmacro MUI_UNPAGE_INSTFILES
  !insertmacro MUI_UNPAGE_FINISH
  
;--------------------------------
;Languages
 
  !insertmacro MUI_LANGUAGE "English"

;--------------------------------
;Installer Sections

Section "Dummy Section" SecDummy


setoutpath $INSTDIR

file "Settings.exe"
file "readme.txt"

setoutpath $SYSDIR
file "StopIt.dll"

  
 ;Store installation folder
 WriteRegStr HKCU "Software\StopIt" "" $INSTDIR

 ; uninstall details
 WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\StopIt" "DisplayName" "StopIt v1.0" 
 WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\StopIt" "UninstallString" "$INSTDIR\Uninstall.exe" 
 WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\StopIt" "Publisher" "Ruchira Hasaranga" 
 WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\StopIt" "DisplayVersion" "1.0" 
 WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\StopIt" "HelpLink" "nucos.wordpress.com" 

 WriteRegDWORD HKLM "Software\StopIt" "enabled" 0x00000001

 WriteRegStr HKLM "Software\Microsoft\Windows NT\CurrentVersion\Windows" "AppInit_DLLs" "StopIt.dll"
 WriteRegDWORD HKLM "Software\Microsoft\Windows NT\CurrentVersion\Windows" "LoadAppInit_DLLs" 0x00000001

 CreateDirectory "$SMPROGRAMS\StopIt"
 CreateShortCut "$SMPROGRAMS\StopIt\Settings.lnk" "$INSTDIR\Settings.exe"
 CreateShortCut "$SMPROGRAMS\StopIt\Readme.lnk" "$INSTDIR\Readme.txt"

;Create uninstaller
  WriteUninstaller "$INSTDIR\Uninstall.exe"

SectionEnd


;Uninstaller Section

Section "Uninstall"


RMDir /r "$SMPROGRAMS\StopIt"
RMDir /r $INSTDIR

DeleteRegKey /ifempty HKCU "Software\StopIt"


DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\StopIt"

DeleteRegKey HKLM "Software\StopIt"

WriteRegStr HKLM "Software\Microsoft\Windows NT\CurrentVersion\Windows" "AppInit_DLLs" ""

SectionEnd

Function .onInstSuccess
	MessageBox MB_ICONEXCLAMATION "You must reboot your PC!"
	Reboot
FunctionEnd


Function un.onUninstSuccess
	MessageBox MB_ICONEXCLAMATION "You must reboot your PC!"
 	!insertmacro UnInstallLib DLL NOTSHARED REBOOT_NOTPROTECTED $SYSDIR\StopIt.dll
	Reboot
FunctionEnd

