
#include"BaseUIComponent.h"

BaseUIComponent::BaseUIComponent()
{
	compHWND=0;
	compParentHWND=0;
	compText=0;
	compDwStyle=0;
	compDwExStyle=0;
	compX=CW_USEDEFAULT;
	compY=CW_USEDEFAULT;
	compWidth=CW_USEDEFAULT;
	compHeight=CW_USEDEFAULT;
	compVisible=true;
	compEnabled=true;

	generateClassName(compClassName);

	wc.cbSize=sizeof(WNDCLASSEX);
	wc.hCursor=LoadCursor(NULL,IDC_ARROW);
	wc.hIcon=0;
	wc.lpszMenuName=0;
	wc.hbrBackground=(HBRUSH)GetSysColorBrush(COLOR_BTNFACE);
	wc.cbClsExtra=0;
	wc.cbWndExtra=0;
	wc.hIconSm=0;
	wc.style=0;
	wc.hInstance=getInstance();
	wc.lpszClassName=compClassName;

	hFont=(HFONT)GetStockObject(DEFAULT_GUI_FONT);
}

BaseUIComponent::~BaseUIComponent() // deregister class here...
{}

LRESULT BaseUIComponent::WindowProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam)
{
	return DefWindowProc( hwnd, msg, wparam, lparam );
}

bool BaseUIComponent::CreateComponent() // you must override this method!
{
	return true;
}

void BaseUIComponent::SetFont(HFONT font)
{
	hFont=font;
	if(compHWND)
		SendMessage(compHWND,WM_SETFONT,(WPARAM)hFont,MAKELPARAM(true, 0));
}

wchar_t* BaseUIComponent::GetText()
{
	return compText;
}

void BaseUIComponent::SetText(wchar_t* compText)
{
	this->compText=compText;
	if(compHWND)
		SetWindowText(compHWND,compText);
}

wchar_t* BaseUIComponent::GetClassName()
{
	return compClassName;
}

void BaseUIComponent::SetHWND(HWND compHWND)
{
	this->compHWND=compHWND;
}

HWND BaseUIComponent::GetHWND()
{
	return compHWND;
}

void BaseUIComponent::SetParentHWND(HWND compParentHWND)
{
	this->compParentHWND=compParentHWND;
}

HWND BaseUIComponent::GetParentHWND()
{
	return compParentHWND;
}

DWORD BaseUIComponent::GetStyle()
{
	return this->compDwStyle;
}

void BaseUIComponent::SetStyle(DWORD compStyle)
{
	this->compDwStyle=compStyle;
}

DWORD BaseUIComponent::GetExStyle()
{
	return this->compDwExStyle;
}

void BaseUIComponent::SetExStyle(DWORD compExStyle)
{
	this->compDwExStyle=compExStyle;
}

int BaseUIComponent::GetX()
{
	return compX;
}

int BaseUIComponent::GetY()
{
	return compY;
}

int BaseUIComponent::GetWidth()
{
	return compWidth;
}

int BaseUIComponent::GetHeight()
{
	return compHeight;
}

void BaseUIComponent::SetSize(int compWidth,int compHeight)
{
	this->compWidth=compWidth;
	this->compHeight=compHeight;

	if(compHWND)
		SetWindowPos(compHWND,0,0,0,compWidth,compHeight,SWP_NOMOVE|SWP_NOREPOSITION);
}

void BaseUIComponent::SetPosition(int compX,int compY)
{
	this->compX=compX;
	this->compY=compY;

	if(compHWND)
		SetWindowPos(compHWND,0,compX,compY,0,0,SWP_NOSIZE|SWP_NOREPOSITION);
}

void BaseUIComponent::SetVisible(bool state)
{
	this->compVisible=state;
	ShowWindow(compHWND,state ? SW_SHOW:SW_HIDE);
}

bool BaseUIComponent::IsVisible()
{
	return compHWND ? this->compVisible : false;
}

bool BaseUIComponent::IsEnabled()
{
	return this->compEnabled;
}

void BaseUIComponent::SetEnabled(bool state)
{
	this->compEnabled=state;

	if(compHWND)
		EnableWindow(compHWND,this->compEnabled);
}

void BaseUIComponent::BringToFront()
{
	if(compHWND)
		BringWindowToTop(compHWND);
}

void BaseUIComponent::SetKeyboardFocus()
{
	if(compHWND)
		SetFocus(compHWND);
}

void BaseUIComponent::Repaint()
{
	if(compHWND)
	{
		InvalidateRect(compHWND, NULL, FALSE);
		UpdateWindow(compHWND); 
	}
}