
#include"BaseUI.h"
#include"BUIWindow.h"

BUIWindow::BUIWindow()
{
	SetText(L"BUIWindow");
	SetSize(400,200);
	SetStyle(WS_OVERLAPPEDWINDOW|WS_CLIPSIBLINGS);
	SetExStyle(WS_EX_APPWINDOW|WS_EX_ACCEPTFILES|WS_EX_CONTROLPARENT);
	wc.style=CS_HREDRAW | CS_VREDRAW;
	wc.lpfnWndProc=GlobalWnd_Proc;
}

BUIWindow::~BUIWindow()
{
	UnregisterClass(compClassName,getInstance());
}

bool BUIWindow::CreateComponent()
{

	if(!RegisterClassEx(&wc))
		return false;

	CreateBUIControl(this);

	if(compHWND)
	{
		EnableWindow(compHWND,compEnabled);

		if(this->IsVisible())
			this->SetVisible(true);
		return true;
	}
	return false;	
}

LRESULT BUIWindow::WindowProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam)
{

	switch(msg)
	{
	case WM_COMMAND:
		if(!this->onWMCommand(wparam,lparam))
			return BaseUIComponent::WindowProc(hwnd,msg,wparam,lparam);
		break;
	case WM_HSCROLL:
		if(!this->onWMHScroll(wparam,lparam))
			return BaseUIComponent::WindowProc(hwnd,msg,wparam,lparam);
		break;
	case WM_VSCROLL:
		if(!this->onWMVScroll(wparam,lparam))
			return BaseUIComponent::WindowProc(hwnd,msg,wparam,lparam);
		break;
	case WM_CONTEXTMENU:
		this->onContextMenu();
		break;
	case WM_CREATE:
		this->onCreate();
		break;
	case WM_CLOSE:
		this->onClose();
		break;
	case WM_DESTROY:
		this->onDestroy();
		break;
	default:
		return BaseUIComponent::WindowProc(hwnd,msg,wparam,lparam);
	}

	return 0;
}

bool BUIWindow::onWMHScroll(WPARAM wparam, LPARAM lparam) // if you process given msg, then return true!
{
	int nScrollCode = (int)LOWORD(wparam);

	if( (nScrollCode==SB_THUMBTRACK )||(nScrollCode==SB_THUMBPOSITION )||(nScrollCode==SB_LINELEFT)||(nScrollCode==SB_LINERIGHT)||(nScrollCode==SB_PAGELEFT)||(nScrollCode==SB_PAGERIGHT) )
		return this->onThumbChange((HWND)lparam);

	return false;
}

bool BUIWindow::onWMVScroll(WPARAM wparam, LPARAM lparam) // if you process given msg, then return true!
{
	int nScrollCode = (int)LOWORD(wparam);

	if( (nScrollCode==SB_THUMBTRACK )||(nScrollCode==SB_THUMBPOSITION )||(nScrollCode==SB_LINELEFT)||(nScrollCode==SB_LINERIGHT)||(nScrollCode==SB_PAGELEFT)||(nScrollCode==SB_PAGERIGHT) )
		return this->onThumbChange((HWND)lparam);

	return false;
}

bool BUIWindow::onThumbChange(HWND hwnd)
{
	return false;
}

bool BUIWindow::onWMCommand(WPARAM wparam, LPARAM lparam) // if you process given msg, then return true!
{
	if(this->onMenuItemPress(LOWORD(wparam))) // menu item press msg also come with BN_CLICKED notification code! so we have to move this handler into the top!
		return true;
	else if(HIWORD(wparam)==BN_CLICKED)
		return this->onButtonPress((HWND)lparam); 
	else if(HIWORD(wparam)==LBN_SELCHANGE)
		return this->onListBoxChange((HWND)lparam);
	else if(HIWORD(wparam)==CBN_SELENDOK)
		return this->onComboBoxChange((HWND)lparam);
	else
		return false;
}

bool BUIWindow::onMenuItemPress(int id)
{
	return false;
}

bool BUIWindow::onButtonPress(HWND hwnd)  // if you process given msg, then return true! otherwise, return parent class "onButtonPress" method return value!
{
	return false;
}

bool BUIWindow::onListBoxChange(HWND hwnd)  // if you process given msg, then return true! otherwise, return parent class "onListBoxChange" method return value!
{
	return false;
}

bool BUIWindow::onComboBoxChange(HWND hwnd)  // if you process given msg, then return true! otherwise, return parent class "onComboBoxChange" method return value!
{
	return false;
}

void BUIWindow::onCreate()
{

}

void BUIWindow::onContextMenu()
{

}

void BUIWindow::onDestroy()
{
	PostQuitMessage(0);
}

void BUIWindow::onClose()
{
	DestroyWindow(compHWND);
}


void BUIWindow::CenterScreen()
{
	SetPosition((GetSystemMetrics(SM_CXSCREEN)-compWidth)/2,(GetSystemMetrics(SM_CYSCREEN)-compHeight)/2);
}
