
#include"BaseUI.h"
#include"BUITrackBar.h"

wchar_t* BUITrackBar::GetText()
{
	return NULL;
}

void BUITrackBar::SetText(wchar_t* compText)
{
}


BUITrackBar::BUITrackBar(bool showTicks,bool vertical)
{

	SetSize(100,25);
	SetPosition(0,0);
	SetStyle(WS_CHILD|WS_CLIPSIBLINGS);
	SetExStyle(WS_EX_WINDOWEDGE);

	if(showTicks)
		SetStyle(GetStyle()|TBS_AUTOTICKS);
	else
		SetStyle(GetStyle()|TBS_NOTICKS);

	if(vertical)
		SetStyle(GetStyle()|TBS_VERT);
	else
		SetStyle(GetStyle()|TBS_HORZ);
}

BUITrackBar::~BUITrackBar()
{
}

void BUITrackBar::SetRange(int min,int max) // you must call this method, after create the component!
{
	if(compHWND)
	{
		SendMessage(compHWND,TBM_SETRANGE,TRUE,(LPARAM) MAKELONG(min,max));
	}
}

void BUITrackBar::SetValue(int pos) // you must call this method, after create the component!
{
	if(compHWND)
	{
		SendMessage(compHWND,TBM_SETPOS,TRUE,(LPARAM)pos);
	}
}

int BUITrackBar::GetValue() // you must call this method, after create the component!
{
	if(compHWND)
	{
		return (int)SendMessage(compHWND,TBM_GETPOS,0,0);
	}else
		return -1;
}

bool BUITrackBar::CreateComponent()
{
	if(!compParentHWND) // user must specify parent handle!
		return false;

	compHWND=CreateWindowEx(GetExStyle(),TRACKBAR_CLASS,GetText(),GetStyle(),GetX(),GetY(),GetWidth(),GetHeight(),GetParentHWND(),0,getInstance(),0);

	if(compHWND)
	{

		EnableWindow(compHWND,compEnabled);

		if(this->IsVisible())
			this->SetVisible(true);
		return true;
	}
	return false;	
}